package limit;

import com.af.plugins.DateTools;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CalLimitGas {

    public static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");


    public static void main(String[] args) throws Exception {
        // 月数差值

        String startDate = "2019-10-28";

        String endDate = "2019-11-02";

        String cycle = "10";

        System.out.println("结果" + getCycleStartDateByMonth(startDate, endDate, cycle));
        System.out.println("结果" + getCycleStartDateByDay(startDate, endDate, cycle));
    }

    // 按月的话，计算两个时间的月数

    public static String getCycleStartDateByMonth(String startDate, String endDate, String cycleInt)  throws ParseException {

        int cycle = Integer.parseInt(cycleInt);

        Calendar start = Calendar.getInstance();

        Calendar end = Calendar.getInstance();

        start.setTime(format.parse(startDate));
        end.setTime(format.parse(endDate));

        // 获取两个时间的月数差

        int startYear = start.get(Calendar.YEAR);
        int endYear = end.get(Calendar.YEAR);
        int startMonth = start.get(Calendar.MONTH);
        int endMonth = end.get(Calendar.MONTH);
        int startDay = start.get(Calendar.DAY_OF_MONTH);
        int endDay = end.get(Calendar.DAY_OF_MONTH);


        Calendar result = Calendar.getInstance();

        result.set(Calendar.YEAR, endYear);

        int t = ((endYear - startYear) * 12 + endMonth - startMonth) % cycle;

        if (endDay < startDay && t == 0) {
            result.set(Calendar.MONTH, endMonth - cycle);
        } else {
            result.set(Calendar.MONTH, endMonth - t);
        }
        result.set(Calendar.DAY_OF_MONTH, startDay);

        return format.format(result.getTime());
    }

    public static String getCycleStartDateByDay(String startDate, String endDate, String cycleInt)  throws ParseException {

        int cycle = Integer.parseInt(cycleInt);

        Calendar now = Calendar.getInstance();
        now.setTime(format.parse(endDate));

        Date start = format.parse(startDate);
        Date end = format.parse(endDate);

        long betweenDate = (end.getTime() - start.getTime())/(60*60*24*1000);

        int a = (int)betweenDate % cycle;

        Calendar result = Calendar.getInstance();

        result.set(Calendar.YEAR, now.get(Calendar.YEAR));
        result.set(Calendar.MONTH, now.get(Calendar.MONTH));
        result.set(Calendar.DAY_OF_MONTH, now.get(Calendar.DAY_OF_MONTH) - a);

        return format.format(result.getTime());
    }

}
