package filiale.gongyi;

import com.af.plugins.CommonTools;
import com.af.plugins.DateTools;
import com.aote.logic.LogicServer;
import com.aote.rs.mapper.WebException;
import org.json.JSONArray;
import org.json.JSONObject;
import util.SaleDateUtil;

import java.math.BigDecimal;

/**
 * @Author: JoeCdy
 * @Description:
 * @Date: Created in 10:46 2020/9/25
 */
public class LateFeeCalculation {

    /**
     * 巩义滞纳金计算
     *
     * @param data 原数据
     * @return 添加滞纳金后的数据
     */
    public static JSONArray calculate(JSONArray data, LogicServer logicServer) {
        try {
            // 第一条欠费
            JSONObject data0 = data.getJSONObject(0);
            // 第一条欠费录入日期
            String f_input_date0 = data0.getString("f_input_date");
            // 滞纳金开始计算日期
            String endDate = DateTools.nextMonth(f_input_date0, "1");

            // 第一条欠费下发日期
            String f_hand_date0 = data0.getString("f_hand_date");
            // 非民用滞纳金开始计算日期
            String noCivilEndDate = DateTools.nextMonth(f_hand_date0, "1");

            // 现在日期
            String nowDate = DateTools.getNow2();
            // 用户类型
            String f_user_type = data0.getString("f_user_type");
            // 先计算第一条
            if ("民用".equals(f_user_type)) {
                // 录入月份的月底之前不算滞纳金
                if (DateTools.compareDate(nowDate, endDate)) {
                    LateFeeCalculation.calculateSingle(data0, data0.getBigDecimal("f_balance"));
                }
            } else {
                // 非民用下发月份的月底之前不算滞纳金
                if (DateTools.compareDate(nowDate, noCivilEndDate)) {
                    LateFeeCalculation.industryCalculate(data0, noCivilEndDate);
                }
            }
            // 循环计算剩下的
            for (int i = 1; i < data.length(); i++) {
                JSONObject jsonObject = data.getJSONObject(i);
                // 欠费录入日期
                f_input_date0 = jsonObject.getString("f_input_date");
                // 滞纳金开始计算日期
                endDate = DateTools.nextMonth(f_input_date0, "1");

                // 欠费下发日期
                f_hand_date0 = jsonObject.getString("f_hand_date");
                // 非民用滞纳金开始计算日期
                noCivilEndDate = DateTools.nextMonth(f_hand_date0, "1");

                if ("民用".equals(f_user_type)) {
                    if (DateTools.compareDate(nowDate, endDate)) {
                        LateFeeCalculation.calculateSingle(jsonObject, new BigDecimal("0"));
                    }
                } else {
                    if (DateTools.compareDate(nowDate, noCivilEndDate)) {
                        LateFeeCalculation.industryCalculate(jsonObject, noCivilEndDate);
                    }
                }
            }
        } catch (Exception e) {
            logicServer.debug("计算滞纳金报错: ", e);
            throw new WebException(500, "计算滞纳金报错: " + e.getMessage());
        }
        return data;
    }

    private static JSONObject calculateSingle(JSONObject json, BigDecimal f_balance) throws Exception {
        String f_input_date = json.getString("f_input_date");
        String f_last_input_date = json.getString("f_last_input_date");
        // 现在日期
        String nowDate = DateTools.getNow2();
        // 抄表间隔天数
        int day1 = Integer.parseInt(SaleDateUtil.getDays(f_input_date, f_last_input_date));
        // 抄表间隔天数为0,直接给1
        if (day1 <= 0) { day1 = 1; }
        // 日平均用气金额
        String averageMoney = String.valueOf(CommonTools.div(json.getBigDecimal("f_oughtfee"), day1, 2));
        // 预交天数
        int day2 = (int) CommonTools.div(f_balance, averageMoney, 0);
        // 滞纳金开始计算的日期
        String overdueStartDate = DateTools.getDelayDate(f_last_input_date, "DAY", String.valueOf(day2));
        // 需要缴滞纳金的条数
        int day3 = Integer.parseInt(SaleDateUtil.getDays(f_input_date, overdueStartDate));
        // 预交天数大于滞纳天数不需要缴纳滞纳金
        if (day3 < 0) { return json; }
        // 滞纳天数为0时,给1
        if (day3 == 0) { day3 = 1; }
        // 滞纳金比率
        String zhinajinbilv = String.valueOf(json.getDouble("zhinajinbilv"));
        // 滞纳金明细
        JSONArray overdueDetail = new JSONArray();
        // 滞纳金总和
        BigDecimal overdue = new BigDecimal("0");
        for (int i = 0; i < day3; i++) {
            JSONObject row = new JSONObject();
            // 日期
            String date = DateTools.getDelayDate(overdueStartDate, "DAY", String.valueOf(i));
            row.put("date", date);
            // 天数
            String day = SaleDateUtil.getDays(nowDate, date);
            row.put("day", day);
            // 金额
            BigDecimal money = new BigDecimal(zhinajinbilv).multiply(new BigDecimal(averageMoney)).multiply(new BigDecimal(day)).setScale(2, BigDecimal.ROUND_HALF_UP);
            row.put("money", money);
            // 计算公式
            String formula = averageMoney + "*" + zhinajinbilv + "*" + day;
            row.put("formula", formula);
            overdueDetail.put(row);
            // 计算滞纳金总和
            overdue = CommonTools.add(overdue, money);
        }
        // 抄表间隔天数
        json.put("day1", day1);
        // 预交天数
        json.put("day2", day2);
        // 日平均用气金额
        json.put("averageMoney", averageMoney);
        // 总应交滞纳金(减免后的)
        json.put("overdue", CommonTools.add(overdue, json.get("f_latefee_ought")));
        // 总滞纳金
        json.put("f_overdue", overdue);
        // 滞纳金明细
        json.put("overdueDetail", overdueDetail);
        // 最大滞纳天数
        json.put("overduedays", overdueDetail.getJSONObject(0).getString("day"));
        return json;
    }

    private static JSONObject industryCalculate(JSONObject json, String endDate) throws Exception {
        String f_input_date = json.getString("f_input_date");
        String f_last_input_date = json.getString("f_last_input_date");
        // 用气金额
        BigDecimal f_oughtfee = json.getBigDecimal("f_oughtfee");
        // 现在日期
        String nowDate = DateTools.getNow2();
        // 抄表间隔天数
        int day1 = Integer.parseInt(SaleDateUtil.getDays(f_input_date, f_last_input_date));
        // 抄表间隔天数为0,直接给1
        if (day1 <= 0) { day1 = 1; }
        // 日平均用气金额
        String averageMoney = String.valueOf(CommonTools.div(f_oughtfee, day1, 2));
        // 预交天数
        int day2 = 0;
        // 需要缴滞纳金的天数
        int day3 = Integer.parseInt(SaleDateUtil.getDays(nowDate, endDate)) + 1;
        // 预交天数大于滞纳天数不需要缴纳滞纳金
        if (day3 < 0) { return json; }
        // 滞纳天数为0时,给1
        if (day3 == 0) { day3 = 1; }
        // 滞纳金比率
        String zhinajinbilv = String.valueOf(json.getDouble("zhinajinbilv"));
        // 滞纳金明细
        JSONArray overdueDetail = new JSONArray();
        // 滞纳金总和
        BigDecimal overdue = new BigDecimal("0");

        JSONObject row = new JSONObject();
        // 日期
        row.put("date", endDate);
        // 天数
        String day = String.valueOf(day3);
        row.put("day", day);
        // 金额
        BigDecimal money = new BigDecimal(zhinajinbilv).multiply(f_oughtfee).multiply(new BigDecimal(day)).setScale(2, BigDecimal.ROUND_HALF_UP);
        row.put("money", money);
        // 计算公式
        String formula = f_oughtfee + "*" + zhinajinbilv + "*" + day;
        row.put("formula", formula);
        overdueDetail.put(row);
        // 计算滞纳金总和
        overdue = CommonTools.add(overdue, money);

        // 抄表间隔天数
        json.put("day1", day1);
        // 预交天数
        json.put("day2", day2);
        // 日平均用气金额
        json.put("averageMoney", averageMoney);
        // 总应交滞纳金(减免后的)
        json.put("overdue", CommonTools.add(overdue, json.get("f_latefee_ought")));
        // 总滞纳金
        json.put("f_overdue", overdue);
        // 滞纳金明细
        json.put("overdueDetail", overdueDetail);
        // 最大滞纳天数
        json.put("overduedays", overdueDetail.getJSONObject(0).getString("day"));
        return json;
    }
}
