package com.aote.rs;


import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import com.aote.util.SqlHelper;
import file.ReadFile;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import java.io.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

@Transactional
@Component
@Path("downloadfile")
public class DownloadService {
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    public SessionFactory sessionFactory;
    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    @GET
    @Path("file")
    public void downfiles(@Context HttpServletRequest request,
                          @Context HttpServletResponse response){
        //获取当前公司所属组织
        JSONArray useorgarr = new JSONArray();
        String download_orgid = "";
        try {
            useorgarr = sqlServer.query("select value from  t_singlevalue where name='所属公司'");
        } catch (Exception e) {
            e.printStackTrace();
        }
        if(useorgarr.length() >0){
            String useorgid = ((JSONObject)useorgarr.get(0)).getString("value");
            if(!useorgid.equals("")){
                download_orgid = "_"+((JSONObject)useorgarr.get(0)).getString("value");
            }
        }
        try {
            ReadFile readfile =new ReadFile();
            Map paramMap = request.getParameterMap();
            JSONObject params = new JSONObject(paramMap);
            System.out.println(params);
            if(!params.has("filename")) {
                throw new WebException(708, "请传输下载文件名！");
            }
            String downname = "";
            try{
                JSONArray filenames = (JSONArray) params.get("filename");
                downname = (String) filenames.get(0);
            }catch(Exception e){
                throw new WebException(708, "下载文件名不能为空！");
            }
            String url = "/excel/"+downname+download_orgid+".xlsx";
            String path = readfile.GetResourceURL(url);
            File file = new File(path);
            // 取得文件名。
            String filename = file.getName();
            // 取得文件的后缀名。
            String ext = filename.substring(filename.lastIndexOf(".") + 1).toUpperCase();
            // 以流的形式下载文件。
            InputStream fis = new BufferedInputStream(new FileInputStream(path));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();
            // 设置response的Header
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes("UTF-8"),"ISO-8859-1"));
            response.addHeader("Content-Length", "" + file.length());
            OutputStream toClient = new BufferedOutputStream(response.getOutputStream());
            response.setContentType("application/octet-stream");
            toClient.write(buffer);
            toClient.flush();
            toClient.close();
        } catch (Exception ex) {
            throw new WebException(709, "下载文件不存在！");
        }
    }
}
