package com.af.timingJob;

import com.aote.rs.LogicService;
import file.ReadFile;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;

@Component
@EnableScheduling
@Lazy(false)
public class MeterDown {

    static Logger log = Logger.getLogger(LogicService.class);

    @Autowired
    private LogicService logicService;

    @Scheduled(cron = "0 5 0 * * ? ")
    public void doJob(){
        log.debug("进入了定时器执行定时任务");
        ReadFile file =new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/timerConfig.json"));
        log.debug("获取到的执行配置为---》"+conf.get("MeterDown"));
        if ((boolean)conf.get("MeterDown")){
            try {
                log.debug("开始执行批量抄表");
                logicService.xtSave("batchMain", new JSONObject().put("data", new JSONObject().toString()).toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("未配置启动自动下发");
        }
    }

}
