package com.af.timingJob;

import com.aote.rs.LogicService;
import file.ReadFile;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Component
public class Intermediate {

    static Logger log = Logger.getLogger(LogicService.class);

    private static final List<String> day = new ArrayList<String>();

    private static final List<String> month = new ArrayList<String>();

    static {
        String[] dayArr = {"IntermediateTableUseGas","IntermediateTableSellGas","IntermediateTableDayIncome","IntermediateTableUserAddShut","IntermediateTableUserCount","revenueToKPI"};
        String[] monthArr = {"IntermediateTableHandCount"};
        day.addAll(Arrays.asList(dayArr));
        month.addAll(Arrays.asList(monthArr));
    }

    @Autowired
    private LogicService logicService;

    @Scheduled(cron = "59 9 0 * * ? ")
    public void everyDay(){
        log.debug("开始执行中间表的日定时器");
        ReadFile file =new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/timerConfig.json"));
        if ( ! (boolean) conf.get("Intermediate")){
            log.debug("日定时器未开启");
            return;
        }
        log.debug(LocalDateTime.now()+"开始执行中间表每日定时器");
        day.forEach((v)->{
            log.debug("执行"+v);
            try {
                logicService.xtSave(v,new JSONObject().put("data",new JSONObject()).toString());
            } catch (Exception e) {
                log.error("日执行定时器->"+v+"  Logic执行异常！！");
                e.printStackTrace();
            }
        });
    }
    @Scheduled(cron = "0 15 0 1 * ? ")
    public void everyMonth(){
        log.debug("开始执行中间表的月定时器");
        ReadFile file =new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/timerConfig.json"));
        if ( ! (boolean) conf.get("Intermediate")){
            log.debug("月定时器未开启");
            return;
        }
        log.debug(LocalDateTime.now()+"开始执行中间表【月初】定时器");
        month.forEach((v)->{
            try {
                logicService.xtSave(v,new JSONObject().put("data",new JSONObject()).toString());
            } catch (Exception e) {
                log.error("月执行定时器->"+v+"  Logic执行异常！！");
                e.printStackTrace();
            }
        });
    }
}
