package util.price.util;


import android.annotation.SuppressLint;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

/**
 * AES加密(使用AES-128-ECB加密模式，key需要为16位)
 *
 * @author YinGP
 *
 *         2014年1月3日
 */
public class AES {
    // 加密算法,可用 DES,DESede,Blowfish.
    private final static String ALGORITHM = "AES";
    // 算法/模式/补码方式
    private final static String ALGORITHM_MODE = "AES/ECB/NoPadding";

    /**
     * DES加密
     *
     * @param data
     *            加密数据
     * @param key
     *            密钥
     * @return 密文
     * @throws Exception
     */
    public static String encrypt(String data, String key) throws Exception {
        return byteArr2HexStr(Encrypt(hexStr2ByteArr(data), hexStr2ByteArr(key)));
    }

    /**
     * DES解密
     *
     * @param data
     *            解密数据
     * @param key
     *            密钥
     * @return 明文
     * @throws Exception
     */
    public static String decrypt(String data, String key) throws Exception {
        return byteArr2HexStr(Decrypt(hexStr2ByteArr(data), hexStr2ByteArr(key)));
    }

    /**
     * 加密
     *
     * @param sSrc
     *            明文字节数组
     * @param sKey
     *            密钥字节数组
     * @return
     * @throws Exception
     */
    @SuppressLint("TrulyRandom")
    private static byte[] Encrypt(byte[] sSrc, byte[] sKey) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(sKey, ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM_MODE);
        cipher.init(Cipher.ENCRYPT_MODE, skeySpec);
        byte[] encrypt = cipher.doFinal(sSrc);
        return encrypt;
    }

    /**
     * 解密
     *
     * @param sSrc
     *            密文字节数组
     * @param sKey
     *            密钥字节数组
     * @return
     * @throws Exception
     */
    private static byte[] Decrypt(byte[] sSrc, byte[] sKey) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(sKey, ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM_MODE);// "算法/模式/补码方式"
        cipher.init(Cipher.DECRYPT_MODE, skeySpec);
        byte[] decrypt = cipher.doFinal(sSrc);
        return decrypt;
    }

    /**
     * 将表示16进制值的字符串转换为byte数组
     *
     * @param strIn
     *            需要转换的字符串
     * @return 转换后的byte数组
     * @throws Exception
     *             本方法不处理任何异常，所有异常全部抛出
     */
    private static byte[] hexStr2ByteArr(String strIn) throws Exception {
        byte[] arr = strIn.getBytes();
        int iLen = arr.length;

        // 两个字符表示一个字节，所以字节数组长度是字符串长度除以2
        byte[] arrOut = new byte[iLen / 2];
        for (int i = 0; i < iLen; i = i + 2) {
            String strTmp = new String(arr, i, 2);
            arrOut[i / 2] = (byte) Integer.parseInt(strTmp, 16);
        }
        return arrOut;
    }

    /**
     * 将byte数组转换为表示16进制值的字符串
     *
     * @param arr
     *            需要转换的byte数组
     * @return 转换后的字符串
     * @throws Exception
     *             本方法不处理任何异常，所有异常全部抛出
     */
    private static String byteArr2HexStr(byte[] arr) throws Exception {

        int iLen = arr.length;
        // 每个byte用两个字符才能表示，所以字符串的长度是数组长度的两倍
        StringBuffer sb = new StringBuffer(iLen * 2);
        for (int i = 0; i < iLen; i++) {
            int intTmp = arr[i];
            // 把负数转换为正数
            while (intTmp < 0) {
                intTmp = intTmp + 256;
            }
            // 小于0F的数需要在前面补0
            if (intTmp < 16) {
                sb.append("0");
            }
            sb.append(Integer.toString(intTmp, 16));
        }
        return sb.toString();
    }
}