package util;

import org.json.JSONArray;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;

public class DateProcess {

    /**
     * 判断是否在
     * @param date
     * @param add
     * @param forMate
     * @return
     */
    public boolean isAfter(String date,Integer add,String forMate){
        if(date == null || add == null){
            return false;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);

        return LocalDateTime.now().isAfter(parse.plusMonths(add));
    }

    /**
     * 传入时间 返回增加后的时间
     * @param date
     * @param add
     * @param forMate
     * @return
     */
    public String addDate(String date,Integer add,String forMate){
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return parse.plusMonths(add).format(dtf);

    }

    /**
     * 判断传入时间加上周期是否是本月
     * @param date  传入时间
     * @param period  周期
     * @param forMate  时间格式
     * @return
     */
    public boolean isDoIt(String date,String period,String forMate){
        if(date == null || period == null){
            return false;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        LocalDateTime now = LocalDateTime.now();
        parse = parse.plusMonths(Integer.parseInt(period));
        return now.getYear() == parse.getYear() && now.getMonth() == parse.getMonth() && now.getDayOfMonth() == parse.getDayOfMonth();
    }

    /**
     * 获取本月第一天(数据库格式)
     * @return
     */
    public String getNowMonthFirst(){
        return LocalDateTime.of(LocalDateTime.now().with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }
    /**
     * 获取本月最后一天(数据库格式)
     * @return
     */
    public String getNowMonthLast(){
        return LocalDateTime.of(LocalDateTime.now().with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }


    /**
     * 获取传入时间第一天(数据库格式)
     * @return
     */
    public String getMonthFirst(String date){
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return LocalDateTime.of(parse.with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }
    /**
     * 获取传入时间最后一天(数据库格式)
     * @return
     */
    public String getMonthLast(String date){
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return LocalDateTime.of(parse.with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    /**
     * 获取传入月份的事件转为正常时间格式
     * @param date
     * @return
     */
    public String yearMonthFormatterDate(String date){
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM");
        DateTimeFormatter ove = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDate.parse(date, dtf).atStartOfDay();
        return parse.format(ove);
    }
    /**
     * 获取当天开始的时间
     * @return
     */
    public String getTodayStart(){
        LocalDateTime today_start = LocalDateTime.of(LocalDate.now(),LocalTime.MIN);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(today_start);
    }

    /**
     * 获取当天最后的时间
     * @return
     */
    public String getTodayEnd(){
        LocalDateTime today_start = LocalDateTime.of(LocalDate.now(),LocalTime.MAX);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(today_start);
    }



}
