package util;

import org.apache.commons.codec.binary.Base64;

import java.io.UnsupportedEncodingException;

public class Base64Util {

	/**
	 * 对给定的字符串进行base64解码操作
	 */
	public static byte[] decode(String inputData) {
		try {
			if (null == inputData) {
				return null;
			}
			return  Base64.decodeBase64(inputData.getBytes("UTF-8"));
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
	/**
	 * 对给定的字符串进行base64加密操作
	 */
	public static byte[] encode(String inputData) {
		try {
			if (null == inputData) {
				return null;
			}
			return Base64.encodeBase64(inputData.getBytes("UTF-8"));
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}


	public static void main(String[] args) {
		String a = "20200705145857@350647276333738000";
		System.out.println(encodeData(a));

		String b = "MjAyMDA3MDUxNDU4NTdAMzUwNjQ3Mjc2MzMzNzM4MDAw";
		System.out.println(decodeData(b));

	}

	/**
	 * 对给定的字符串进行base64解码操作
	 */
	public static String decodeData(String inputData) {
		try {
			if (null == inputData) {
				return null;
			}
			return new String(Base64.decodeBase64(inputData.getBytes("UTF-8")), "UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * 对给定的字符串进行base64加密操作
	 */
	public static String encodeData(String inputData) {
		try {
			if (null == inputData) {
				return null;
			}
			return new String(Base64.encodeBase64(inputData.getBytes("UTF-8")), "UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
	/**
	 * 对给定的byte[]进行base64加密操作
	 */
	public static String encode(byte[] bytes) {
		if (null == bytes) {
			return null;
		}
		return new String(Base64.encodeBase64(bytes));

	}
}
