package meter;
import com.af.plugins.RestTools;
import com.aote.entity.EntityServer;
import com.aote.rs.mapper.WebException;
import com.aote.util.ExcelUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;

/**
 * 批量sql的操作
 */
public class SettleTools {
    public final static String XLS = "xls";
    public final static String XLSX = "xlsx";
    static Logger log = Logger.getLogger(EntityServer.class);

    /**
     * 获取批量sql的values
     */
    public static String getAllsomeValue(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql values获取");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();
                Object value = (Object)map.get(key);
                sbs.append("'");
                sbs.append(value);
                sbs.append("'");
                if(iterator.hasNext()){
                    sbs.append(",");
                }
            }
            if(i == json.length()-1){
                sbs.append(")");
            }else{
                sbs.append("),");
            }
        }
        return sbs.toString();
    }
    /**
     * 获取批量sql的fileds
     * @param json
     * @return
     */
    public static String getAllsomFields(JSONArray json){
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            String nowLineValue = "";
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();

                sbs.append(key);
                if (iterator.hasNext()) {
                    sbs.append(",");
                }

            }
            sbs.append(")");
            break;
        }
        return sbs.toString();
    }

    /**
     * 获取批量sql的values
     */
    public static String getAllValue(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql values获取");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();
                Object value = (Object)map.get(key);
                sbs.append("'");
                sbs.append(value);
                sbs.append("'");
                if(iterator.hasNext()){
                    sbs.append(",");
                }
            }
            if(i == json.length()-1){
                sbs.append(")");
            }else{
                sbs.append("),");
            }
        }
        return sbs.toString();
    }

    /**
     * 获取特殊批量sql的fileds
     * @param json
     * @return
     */
    public static String getjsonAllFields(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql fields");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");

            sbs.append("f_userinfo_code,");
            sbs.append("f_meternumber,");
            sbs.append("f_tablebase");
            sbs.append(")");
            break;
        }

        return sbs.toString().replace(",)",")");
    }
    /**
     * 获取特殊批量sql的values  {key:{}}
     */
    public static String getjsonAllValue(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql values获取");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            JSONObject maps = (JSONObject)json.get(i);
            JSONObject map = (JSONObject) maps.get("batchsttle");
            if(map.isNull("f_userinfo_code")){
                sbs.append("'0'");
            }else{
                String f_userinfo_code = (String) map.get("f_userinfo_code");
                sbs.append("'"+f_userinfo_code+"'");
            }
            sbs.append(",");
            if(map.isNull("f_meternumber")){
                sbs.append("'0'");
            }else{
                String f_meternumber = (String) map.get("f_meternumber");
                sbs.append("'"+f_meternumber+"'");
            }
            sbs.append(",");
            if(map.isNull("f_tablebase")){
                sbs.append(0);
            }else{
                sbs.append(map.get("f_tablebase"));
            }
            if(i == json.length()-1){
                sbs.append(")");
            }else{
                sbs.append("),");
            }
        }
        return sbs.toString().replace(",)",")");
    }

    /**
     * 获取批量sql的fileds
     * @param json
     * @return
     */
    public static String getAllFields(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql fields");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            String nowLineValue = "";
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();

                sbs.append(key);
                if (iterator.hasNext()) {
                    sbs.append(",");
                }

            }
            sbs.append(")");
            break;
        }
        return sbs.toString();
    }

    public static List<String[]> getExcelData(String filepath){
        List<String[]> data = null;
        InputStream is = null;
        try{
            filepath = filepath.replaceAll("\\\\", "/");
            String jsonString = "{\"filepath\":\""+filepath+"\"}";
            HttpEntity httpEntity = RestTools.postHttpEntity("/rs/file/getUploadFile",new JSONObject(jsonString));
            is = httpEntity.getContent();
        }catch(Exception e){
            throw new WebException(500, filepath+"您所选的文件不存在!!!");
        }
        filepath = filepath.replace("\\", "/");
        String fileName = filepath.split("/")[filepath.split("/").length - 1];
        if (fileName.endsWith("xls") || fileName.endsWith("xlsx")) {
            try {
                data = readExcel(is, fileName);
            } catch (IOException e) {
                throw new WebException(500, "文件解析错误!!!");
            }
        } else {
            throw new WebException(500, "非excel文件暂时未作处理.如有需求,请联系开发人员!!!!");
        }
        return data;
    }

    /**
     * 获取excel多少行
     */
    public static int getExcelLine(String filepath){
        List<String[]> data = getExcelData(filepath);
        if(data.size()>0){
            return data.size();
        }
        return 0;
    }

    /**
     * 获取excel字段数量
     * @param filepath
     * @return
     */
    public static int  getExcelParseJson(String filepath){
        List<String[]> data = getExcelData(filepath);
        if(data.size()>0){
            String[] strings = data.get(0);
            return strings.length;
        }
        return 0;
    }

    /**
     * 读入excel文件，解析后返回
     */
    public static List<String[]> readExcel(InputStream is, String fileName) throws IOException {
        // 检查文件
        checkFile(is);
        // 获得Workbook工作薄对象
        Workbook workbook = getWorkBook(is, fileName);
        // 创建返回对象，把每行中的值作为一个数组，所有行作为一个集合返回
        List<String[]> list = new ArrayList<>();
        if (workbook != null) {
            for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); sheetNum++) {
                // 获得当前sheet工作表
                Sheet sheet = workbook.getSheetAt(sheetNum);
                if (sheet == null) {
                    continue;
                }
                // 获得当前sheet的开始行
                int firstRowNum = sheet.getFirstRowNum();
                // 获得当前sheet的结束行
                int lastRowNum = sheet.getLastRowNum();
                if (sheetNum == 0) {
                    firstRowNum = firstRowNum - 1;
                }
                // 循环除了第一行的所有行
                // 列数以第一行为准
                int lastCellNum = 0;
                for (int rowNum = firstRowNum + 1; rowNum <= lastRowNum; rowNum++) {
                    // 获得当前行
                    Row row = sheet.getRow(rowNum);
                    if (row == null) {
                        continue;
                    }
                    // 获得当前行的开始列
                    int firstCellNum = row.getFirstCellNum();
                    // 获得当前行的列数
//                    int lastCellNum = row.getPhysicalNumberOfCells();
                    if (rowNum == 0) {
                        lastCellNum = row.getPhysicalNumberOfCells();
                    }
                    String[] cells = new String[lastCellNum];
                    // 循环当前行
                    for (int cellNum = firstCellNum; cellNum < lastCellNum; cellNum++) {
                        Cell cell = row.getCell(cellNum);
                        cells[cellNum] = getCellValue(cell);
                    }
                    if (validateCells(cells)) {
                        list.add(cells);
                    }
                }
            }
            workbook.close();
        }
        return list;
    }
    private static void checkFile(InputStream is) throws IOException {
        // 判断文件是否存在
        if (null == is) {
            log.error("文件不存在！");
            throw new FileNotFoundException("文件不存在！");
        }
    }
    private static Workbook getWorkBook(InputStream is, String fileName) {
        //创建Workbook工作薄对象，表示整个excel
        Workbook workbook = null;
        try {
            // 获取excel文件的io流
            //InputStream is = file.getInputStream();
            // 根据文件后缀名不同(xls和xlsx)获得不同的Workbook实现类对象
            if (fileName.endsWith(XLS)) {
                // 2003
                workbook = new HSSFWorkbook(is);
            } else if (fileName.endsWith(XLSX)) {
                // 2007
                workbook = new XSSFWorkbook(is);
            }
        } catch (IOException e) {
            log.info(e.getMessage());
        }
        return workbook;
    }
    public static boolean validateCells (String[] cells) {
        for (String str: cells) {
            if (str != null && !"".equals(str)) {
                return true;
            }
        }
        return false;
    }
    private static String getCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        // 把数字当成String来读，避免出现1读成1.0的情况
        if (cell.getCellType() == Cell.CELL_TYPE_NUMERIC) {
            cell.setCellType(Cell.CELL_TYPE_STRING);
        }
        // 判断数据的类型
        switch (cell.getCellType()) {
            case Cell.CELL_TYPE_NUMERIC: // 数字
                cellValue = String.valueOf(cell.getNumericCellValue());
                break;
            case Cell.CELL_TYPE_STRING: // 字符串
                cellValue = String.valueOf(cell.getStringCellValue());
                break;
            case Cell.CELL_TYPE_BOOLEAN: // Boolean
                cellValue = String.valueOf(cell.getBooleanCellValue());
                break;
            case Cell.CELL_TYPE_FORMULA: // 公式
                cellValue = String.valueOf(cell.getCellFormula());
                break;
            case Cell.CELL_TYPE_BLANK: // 空值
                cellValue = "";
                break;
            case Cell.CELL_TYPE_ERROR: // 故障
                cellValue = "非法字符";
                break;
            default:
                cellValue = "未知类型";
                break;
        }
        return cellValue;
    }

    public static double getValue(String value){
        if(value== null || "".equals(value)){
            return 0;
        }
        Double doubles = new Double(value);
        double ceil= Math.round(doubles);
        return new Double(ceil);
    }

    /**
     * 验证数据是否一致
     * @return
     */
    public static String checkData(String json,String json2){
        if(json == null || json2 == null){
            return "";
        }
        String newjson = json.substring(1,json.length()-1)+",''";
        String newjson2 = json2.substring(1,json2.length()-1)+",''";
        String[] split = newjson.split(",");
        String[] split1 = newjson2.split(",");
//        if(split.length == split1.length){
//            return "";
//        }
        List<String> list1 = Arrays.asList(split1); //将t1数组转成list数组
        List<String> list2 = new ArrayList<String>();//用来存放2个数组中不相同的元素
        for (String t : split) {
            if (!list1.contains(t)) {
                list2.add(t);
            }
        }
        if(list2.size() == 0){
            return "";
        }
        String[] strings = new String[list2.size()];
        String[] strarr = (String[])list2.toArray(strings);
        String join = StringUtils.join(strarr, ",");
        return join;
    }

    /**
     * 判断字符串或者数字是否相等
     * @param num1
     * @param num2
     * @return
     */
    public static boolean judgeValue(Object num1,Object num2){
        if(num1==null || num2==null){
            return false;
        }
        float judgenum1 = 0;
        float judgenum2 = 0;
        if(num1 instanceof Integer && num2 instanceof  Integer){
            if(num1 == num2 ) return true; else return false;
        }
        try{
            if(num1 instanceof Integer){
                judgenum1 = Float.parseFloat(Integer.toString((Integer) num1));
            }else{
                judgenum1 = Float.parseFloat((String)num1);
            }
        }catch(Exception e){
            return false;
        }
        try{
            judgenum2 = Float.parseFloat(num2.toString());
        }catch(Exception e){
            return false;
        }
        if(num1 instanceof String && num2 instanceof  String){
            if(num1.equals(num2)) return true; else return false;
        }
        if(judgenum1-judgenum2 ==0){
            return true;
        }
        return false;
    }

    public static void main(String[] args) {

        Boolean s = SettleTools.judgeValue("0","0.0");
        System.out.println(s);


    }
}
