package com.aote.rs;

import com.aote.plugins.impexp.FileManager;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import java.util.Map;


// rs/settlement/get
@Path("settlement")
public class SettlementService {
	static Logger log = Logger.getLogger(SettlementService.class);

	@Autowired
	private LogicService logicService;
	@Autowired
    private SqlService sqlService;
	@Autowired
	private SqlServer sqlServer;
	@Autowired
	private FileManager fileManager;


	@POST
	@Path("hand")
	public void get(String values, @Context HttpServletRequest request) throws Exception {
		String createTempDataSql = "create table #Tmp\n" +
				"    (\n" +
				"        id int identity(1,1) primary key,\n" +
				"        f_userinfo_code varchar(255) NOT NULL,\n" +
				"        f_meter_classify varchar(80) NULL,\n" +
				"        f_balacne varchar(80) NULL,\n" +
				"        f_meter_base varchar(80) NULL,\n" +
				"        f_batch_number varchar(80) NULL,\n" +
				"        f_whether_pay varchar(80) NULL,\n" +
				"        f_origid varchar(80) NULL,\n" +
				"        startDate varchar(80) NULL,\n" +
				"        endDate varchar(80) NULL)";
		//执行创建临时表sql
		sqlServer.run(createTempDataSql);
		//获取请求参数
		Map paramMap = request.getParameterMap();
		String filepath = (String)paramMap.get("filepath");

		//读取excel文件
		JSONArray excelData = fileManager.read(filepath, "batchMeterSettle.json");
		//循环,每次将1000条数据放在临时表中
        StringBuffer sbf = new StringBuffer();
        for(int i=0;i<1000;i++){
            String o = (String) excelData.get(i);
            if(i==100-1){
                sbf.append(o);
            }else{
                sbf.append(o+",");
            }
        }

        //组合sql

        String insetTempsql = "insert into #Tmp values()";

		JSONArray array = new JSONArray(sqlService.txExecute("",0,1000,""));
		array.forEach((item) -> {
			try {
                logicService.xtSave("ddd",item.toString());
            } catch (Exception e) {
                log.error(e);
            }
        });
	}

	public void saveToTemp(JSONArray jsonarr){
		//jsonarr.
	}
}
