select
   f_userinfo_id,
   f_user_id,
   f_last_tablebase,
   count(*) c
from
(
select
            f_userinfo_id,
			f_user_id,
			f_user_name,
			f_slice_area,
			f_address,
			f_user_phone,
			f_gasproperties,
			meternumbers f_meternumber,
			f_inputtor,
			f_total_fee,
			f_last_tablebase,
			f_tablebase,
			f_real_amount,
			isnull(f_real_fee,0) f_real_fee,
			f_surplus_fee,
		    f_hand_date,
		    f_meter_state,
		    f_type,
		    f_user_type,
			f_meter_classify,
			isnull(f_remanent_money,0) f_remanent_money,
			f_correct_state,
			id,
			f_meter_base,
			f_price_name,
			f_filiale,
			'' f_card_reason,
			f_special_user
from (
select
	*,
	case when f_meter_state!='未抄表' then 1
		else (
			case when maxdate is null then 0
				else (
					case when maxdate>'{endDate}' then 0
						else (
							case when f_hand_date is null then 0
							 else (
							   case when maxdate>f_hand_date then 0 else 1 end
							 ) end
						) end
				) end
			) end f_state,
	case when f_meter_state!='已抄表' then 1
		else (
			case when maxdate != f_hand_date then 1 else 0 end
			) end f_correct_state
from (
	select u.*,
		--首先判断卡表用户是否有最大日期的抄表记录
		--第二判断用户当前归属期内有无抄表记录
		--第三判断用户抄表周期前是否有抄表记录
		--第四判断用户是否有换表记录
		--第五判断用户最大换表时间是否大于最大抄表时间
		case when c.meternumber is null then u.f_meternumber else c.meternumber end meternumbers,
		case when maxdate is null then 0
			else (
				case when c.f_tablebase is not null then c.f_last_tablebase
					else (
						case when t.f_tablebase IS NULL then 0
							else (
								case when f_maxdate is null then t.f_tablebase
									else (
									 case when f_maxdate>maxdate then convert(decimal(18,0),f_newmeter_base)
										else t.f_tablebase end
									) end
							) end
					) end
			) end f_last_tablebase,
         case when t.f_tablebase is null and c.f_tablebase is null  then 0
             when c.f_tablebase is not null then c.f_tablebase
             when t.f_tablebase is not null and c.f_tablebase is null then 0
             end f_tablebase,
				c.f_real_amount,
				c.f_real_fee,
		isnull(c.f_surplus_fee, 0) as f_surplus_fee,
		c.f_hand_date,
		c.id,
	    case when c.id is null
	          then '未抄表'
	    else c.f_meter_state end f_meter_state,
	    c.f_type,
	    maxdate
	from
	(
		--查询所有卡表抄表用户
		select
		    u1.f_special_user,
			u.f_card_id,
			u.f_userinfo_id,
			u.f_meternumber,
			u.f_total_fee,
			u.f_meter_base,
			u.f_user_type,
			u.f_gasproperties,
			u1.f_address,
			u1.f_user_phone,
			u.f_initial_base,
			f_user_id,
			u.f_meter_classify,
			u1.f_user_name,
			s.f_price_name,
			u1.f_slice_area,
			u.f_inputtor,
			u.f_filiale,
			u.f_outlets,
			u.f_remanent_money
		from
		(select  f_card_id,f_userinfo_id,f_meternumber,
		        f_total_fee,f_meter_base,f_user_type,
		        f_gasproperties,f_initial_base,f_user_id,
		        f_meter_classify,f_inputtor,f_filiale,
			    f_outlets,f_remanent_money,f_price_id from t_userfiles
			where f_table_state='正常' and f_meter_classify like '%卡表%'
		) u
		join
		(select f_userinfo_id,f_special_user,f_address,f_user_name,f_slice_area,f_user_phone from t_userinfo
		 where f_user_state='正常'
		) u1 on u.f_userinfo_id=u1.f_userinfo_id
		left join (select * from t_stairprice
		 where f_state='有效'
		) s on u.f_price_id = s.f_price_id
	) u
	left join
	(
	  --查询归属期内有抄表的用户抄表记录
	  select ch.f_tablebase,ch.f_last_tablebase,ch.f_user_id,
	         ch.f_real_amount,ch.f_real_fee,ch.f_hand_date,ch.id,
	         ch.f_meter_state, s.f_surplus_fee,s.f_type,ch.f_meternumber meternumber
	  from t_cardhand ch
		LEFT JOIN (select f_hand_id,f_type,sum(f_surplus_fee) f_surplus_fee from t_surplus_detail
		    where f_surplus_fee>0 and f_type='金额表补差' group by f_hand_id,f_type) s
		on ch.id = s.f_hand_id
	  where ch.f_hand_date>='{startDate} 00:00:00' and ch.f_hand_date<='{endDate} 23:59:59'
	  and f_meter_state != '冲正'
	) c on u.f_user_id=c.f_user_id
  LEFT JOIN
  (
	--查询卡表抄表的用户的查询日期前的最大抄表底数
   select distinct max(c.f_tablebase) f_tablebase,c.f_user_id from(
	   select f_user_id,MAX(f_hand_date) f_hand_date from t_cardhand
	   where f_hand_date<'{endDate} 23:59:59' and f_meter_state != '冲正'
	   GROUP BY f_user_id
	   ) t
	   left JOIN
		t_cardhand c on t.f_user_id=c.f_user_id and t.f_hand_date=c.f_hand_date
		where f_meter_state != '冲正'
	  group by  c.f_user_id
  ) t on u.f_user_id=t.f_user_id
  left join
  (
	--查询卡表用户最大抄表时间
	 select f_user_id,MAX(f_hand_date) maxdate from t_cardhand
	 where f_meter_state != '冲正'
	  GROUP BY f_user_id
  ) t1 on u.f_user_id=t1.f_user_id
  left join
  (
	--查询换表用户的换表时间
	  select f_user_id,max(f_operate_date) f_maxdate
		from t_changemeter
	 where f_changemeter_state='有效'
	 group by  f_user_id
  ) cm on u.f_user_id=cm.f_user_id
  left join
  (select f_user_id cms_userid,f_operate_date cms_date,f_newmeter_base
   from t_changemeter where f_changemeter_state='有效'
  ) cms on cm.f_user_id = cms.cms_userid and cm.f_maxdate = cms.cms_date
) t
) t
union all
--查询卡表冲正记录
select      c.f_userinfo_id,
			f_user_id,
			f_user_name,
			'' f_slice_area,
			f_address,
			f_user_phone,
			f_gasproperties,
			f_meternumber f_meternumber,
			f_inputtor,
			0 f_total_fee,
			f_last_tablebase,
			f_tablebase,
			f_real_amount,
			isnull(f_real_fee,0) f_real_fee,
			f_surplus_fee,
		  f_hand_date,
		  '冲正' f_meter_state,
		  '' f_type,
		  f_user_type,
			'' f_meter_classify,
			0 f_remanent_money,
			1 f_correct_state,
			id,
			0 f_meter_base,
			'' f_price_name,
			f_filiale,
			isnull(f_card_reason,'') f_card_reason,
			u.f_special_user
from
(
    select * from t_cardhand
    where f_hand_date>='{startDate} 00:00:00' and
    f_hand_date<='{endDate} 23:59:59'
    and ((f_meter_state = '已抄表' and id in
    (select f_correct_id from t_correcthandplan
     where f_correct_type='卡表抄表冲正'))
    or f_meter_state = '冲正')
) c
left join
(
 select f_userinfo_id,f_special_user,f_user_phone from t_userinfo)
 u on c.f_userinfo_id=u.f_userinfo_id
) s
where {condition}
group by  f_userinfo_id,f_user_id,f_last_tablebase
having count(*)>1
