/*
 * Decompiled with CFR 0.152.
 */
package eticket;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.json.JSONArray;
import org.json.JSONObject;

public class EticketPlugin {
    public String getSerial() {
        LocalDateTime now = LocalDateTime.now();
        return now.format(DateTimeFormatter.ofPattern("yyyyMMddhhmmssSSSS"));
    }

    public JSONArray getBillArr(JSONArray arr) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject o = arr.getJSONObject(i);
            JSONObject bill = this.getBillInfo(o);
            result.put((Object)bill);
        }
        return result;
    }

    public JSONObject getBillInfo(JSONObject object) {
        JSONObject result = new JSONObject();
        result.put("InfoSellerAddressPhone", (Object)object.getString("sfdzdh"));
        result.put("InfoSellerBankAccount", (Object)object.getString("sfyhzh"));
        result.put("InfoCashier", (Object)object.getString("skr"));
        result.put("InfoChecker", (Object)object.getString("fhr"));
        result.put("InfoKind", (Object)"51");
        result.put("SerialNumber", (Object)object.getString("fpqqlsh"));
        result.put("SellTaxCode", (Object)object.getString("sfsbh"));
        result.put("InfoClientName", (Object)(!object.isNull("ghdwmc") ? object.getString("ghdwmc") : ""));
        result.put("InfoClientTaxCode", (Object)(!object.isNull("ghdwsbh") ? object.getString("ghdwsbh") : ""));
        result.put("InfoClientBankAccount", (Object)(!object.isNull("ghdwyhzh") ? object.getString("ghdwyhzh") : ""));
        result.put("InfoClientAddressPhone", (Object)(!object.isNull("ghdwdzdh") ? object.getString("ghdwdzdh") : ""));
        result.put("InfoInvoicer", (Object)object.getString("kpr"));
        result.put("InfoNotes", (Object)(object.has("Notes") ? object.getString("Notes") : ""));
        result.put("totalmoney", (Object)object.getBigDecimal("totalmoney"));
        result.put("taxmoney", (Object)object.getBigDecimal("taxmoney"));
        result.put("KPLX", (Object)"0");
        JSONArray detail = this.reCombine(object.getJSONArray("detail"));
        result.put("Details", (Object)detail);
        return result;
    }

    public JSONArray reCombine(JSONArray arr) {
        JSONArray newArr = new JSONArray();
        for (int i = 0; i < arr.length(); ++i) {
            newArr.put((Object)this.getGoods(arr.getJSONObject(i)));
        }
        return newArr;
    }

    public JSONObject getGoods(JSONObject object) {
        JSONObject result = new JSONObject();
        result.put("ListGoodsName", (Object)object.getString("spmc"));
        result.put("ListStandard", (Object)"");
        result.put("ListPrice", (Object)object.getBigDecimal("dj").setScale(2));
        result.put("ListUnit", (Object)object.getString("dw"));
        result.put("ListNumber", (Object)object.getBigDecimal("spsl").setScale(2));
        result.put("ListPriceKind", (Object)"1");
        result.put("InfoTaxRate", (Object)object.getBigDecimal("sl").setScale(2));
        return result;
    }
}

