/*
 * Decompiled with CFR 0.152.
 */
package com.af.timingJob;

import com.aote.rs.LogicService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@Lazy(value=false)
public class MeterDown {
    @Autowired
    private LogicService logicService;

    @Scheduled(cron="0 50 23 28-31 * ? ")
    public void doJob() {
        if (this.isLastDay()) {
            int mon = LocalDate.now().getMonthValue();
            JSONObject value = new JSONObject();
            value.put("month", (Object)(mon % 2 == 0 ? "\u5947\u6570\u6708" : "\u5076\u6570\u6708"));
            value.put("begin", (Object)LocalDateTime.of(LocalDateTime.now().plusMonths(1L).with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            try {
                this.logicService.xtSave("batchMain", new JSONObject().put("data", (Object)value).toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("\u4e0d\u662f\u6700\u540e\u4e00\u5929");
        }
    }

    public boolean isLastDay() {
        LocalDate lastDay = LocalDate.now().with(TemporalAdjusters.lastDayOfMonth());
        return lastDay.equals(LocalDate.now());
    }
}

