SELECT
u2.f_filialeid,
	u4.f_userinfo_id,
	u4.f_userinfo_code,
	u4.f_user_name,
	u4.f_user_phone,
	u3.f_address,
	u2.f_user_type,
	u2.f_gasproperties,
	u2.f_total_gas,
	u2.f_user_id,
	u2.f_userfiles_id,
	u2.f_meter_base,
	u1.f_source,
	u1.f_meter_type,
	u1.f_stairprice_id,
	u1.f_handplan_id,
	u1.f_meter_brand,
	u1.f_meter_style,
	{addSelectParam}
	u2.f_price_id,
	u2.f_meternumber,
	u1.pregas as 'pregas',
	sp.f_price_name,
	dp.f_price
FROM
	(
		SELECT
		  id as 'f_handplan_id',
			f_userfiles_id,
			f_userinfo_id,
			f_meter_brand,
			f_meter_style,
			f_stairprice_id,
			f_meter_classify f_meter_type,
			f_oughtamount as 'pregas',
			'抄表' f_source
		FROM
			t_handplan
		WHERE
			f_input_date BETWEEN '{startDate} 00:00:00'
		AND '{endDate} 23:59:59'
		AND f_meter_state = '已抄表'
		AND f_hand_state = '有效'
		and id {price_states} in (select f_handplan_id from t_surplus_detail where f_state = '有效')
		GROUP BY
			f_userfiles_id,
			f_userinfo_id,
			f_meter_classify,
			f_meter_brand,
			f_meter_style,
			f_stairprice_id,
			id,
			f_oughtamount
	) u1
LEFT JOIN t_userfiles u2 ON u1.f_userfiles_id = u2.f_userfiles_id
LEFT JOIN t_user_address u3 ON u2.f_useraddress_id = u3.id
{joinTable}
LEFT JOIN (
	SELECT
		*
	FROM
		t_stairprice
	WHERE
		getdate() >= f_perform_date
	AND getdate() <= f_end_date
	AND f_state = '有效'
) sp ON u2.f_price_id = sp.f_price_id
left join t_detailprice dp on sp.id=dp.f_stairprice_id
LEFT JOIN t_userinfo u4 ON u3.f_userinfo_id = u4.f_userinfo_id
WHERE
	{ condition } and dp.f_price_name='1'
AND u1.pregas > 0
ORDER BY
	f_userinfo_code DESC

