select * from(
	select
		u.f_user_name,	    --用户姓名
		ua.f_address,	    --用户地址
		ua.f_residential_area,		    --小区,		    --小区
		u.f_user_state,	    --用户状态
		u.f_userinfo_code,  --用户统一编码
		u.f_user_phone,	    --用户电话
		uf.f_user_type,	    --用户类型
		uf.f_gasproperties,	--用气性质
		uf.f_position,      --安装位置
		uf.f_table_state,	--气表状态
		m1.f_electricity,	--电量等级
		m1.f_signal,		--信号强度
		m1.f_batterylevel,	--电压
		case when m1.f_cycleShutValue = 0 or e.f_is_read = 1 then '正常' else '异常' end f_cycleshutvalue,               --周期关阀状态
		case when m1.f_overCurrentProtection = 0  or e.f_is_read = 1 then '正常' else '异常' end f_overcurrentprotection,--过流保护关阀状态
		case when m1.f_leakageFlag = 0  or e.f_is_read = 1 then '正常' else '异常' end f_leakageflag,		            --关阀走气状态
		case when m1.f_SplitAlarm = 0  or e.f_is_read = 1 then '正常' else '异常' end f_splitalarm,                      --拆表报警状态
		case when m1.f_valveState = 0 then '开阀' else '关阀' end  f_valvestate,	                                        --阀门状态
		case when m1.f_magneticInterference = 0  or e.f_is_read = 1 then '正常' else '异常' end f_magneticinterference,	--磁干扰状态
		case when m1.f_LowLithiumBattery = 0  or e.f_is_read = 1 then '正常' else '异常' end f_lowlithiumbattery,        --锂电低电状态
		uf.f_operator,		  --建档人
		uf.f_meter_classify,  --气表类型
		uf.f_sendsuccess,	  --同步状态
		uf.f_balance_amount,  --剩余金额
		uf.f_meternumber,	  --表钢号
		uf.f_gas_date,	      --开户日期
		uf.f_initial_base,	  --初始底数
		uf.f_meter_base,	  --系统底数
		m1.f_tablebase,		  --最后上报读数
		m1.f_insert_date,	  --系统最后接收时间
		m1.f_last_insertdate, --上次系统接收时间
		m1.f_hand_date,       --最后上报日期
		m1.f_last_hand_date,  --上次上报日期
		s1.f_operate_date,	  --最后缴费日期
		s1.f_collection,	  --最后缴费金额
		gb.f_meter_brand,	  --气表品牌
		gb.f_manufacturers,	  --气表厂家
		gm.f_meter_style,	  --气表型号
        gb.f_alias,           --别名
		uf.f_price_id,	      --气价编号（不显示）
		sp.f_price_type,	  --气价类型
		sp.f_price_name,	  --气价名称
		pf.VALUE,
		uf.f_orgname,
        uf.f_depname
	from t_userfiles uf
		left join t_userinfo u on uf.f_userinfo_id=u.f_userinfo_id
		left join t_gasbrand gb on uf.f_gasbrand_id = gb.id
		left join t_gasmodel gm on uf.f_gasmodel_id = gm.id
		left join (select f_meternumber,max(id) max_metereadid,max(f_insert_date) f_insert_date
				from t_meteread group by f_meternumber) m on uf.f_meternumber=m.f_meternumber
		left join t_meteread m1 on m.max_metereadid=m1.id
		left join (select * from t_exception where data_id!='无抄表记录id') e on m.max_metereadid = e.data_id
		left join (select f_meternumber,max(id) max_sellid
				from t_sellinggas where f_state='有效' and f_collection>0 group by f_meternumber) s on s.f_meternumber=uf.f_meternumber
		left join t_sellinggas s1 on s.max_sellid=s1.id
		left join t_user_address ua on u.f_userinfo_id = ua.f_userinfo_id
		left join (select * from t_stairprice where f_state='有效')	sp on uf.f_price_id=sp.f_price_id
		left join (SELECT f_stairprice_id,VALUE= (STUFF((SELECT '/' + CONVERT ( VARCHAR ( 12 ), f_price ) FROM t_detailprice WHERE f_stairprice_id = Test.f_stairprice_id FOR XML PATH ( '' ) ),1,1,'' ) )
		FROM t_detailprice AS Test GROUP BY f_stairprice_id ) pf ON (pf.f_stairprice_id= sp.id)
) u
where {condition}