package meter;

import com.aote.entity.EntityServer;
import com.aote.plugins.ServiceNoGenerator;
import com.aote.plugins.ThreadTool;
import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * 批量sql的操作
 */
public class SettleTools {
    static Logger log = Logger.getLogger(EntityServer.class);

    private static ThreadTool threadTool = new ThreadTool();
    @Autowired
    private static ServiceNoGenerator serviceNoGenerator;

    /**
     * 获取批量sql的values
     */
    public static String getAllValue(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql values获取");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            JSONObject map = (JSONObject)json.get(i);
            JSONObject addressmap =(JSONObject)map.get("useraddress");
            Iterator<String> iterator = addressmap.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();
                Object value = (Object)addressmap.get(key);
                sbs.append("'");
                sbs.append(value);
                sbs.append("'");
                if(iterator.hasNext()){
                    sbs.append(",");
                }
            }
            if(i == json.length()-1){
                sbs.append(")");
            }else{
                sbs.append("),");
            }
        }
        return sbs.toString();
    }
    /**
     * 获取批量sql的fileds
     * @param json
     * @return
     */
    public static String getAllFields(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql fields");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            String nowLineValue = "";
            JSONObject map = (JSONObject)json.get(i);
            JSONObject addressmap =(JSONObject)map.get("useraddress");
            Iterator<String> iterator = addressmap.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();

                sbs.append(key);
                if (iterator.hasNext()) {
                    sbs.append(",");
                }

            }
            sbs.append(")");
            break;
        }
        return sbs.toString();
    }

    /**
     * 获取批量sql的values
     */
    public static String getAllnewValue(JSONArray json,JSONObject other){
//        log.info("将要进行"+json.length()+"批量sql values获取");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            JSONObject map = (JSONObject)json.get(i);
            JSONObject addressmap =(JSONObject)map.get("useraddress");
            Iterator<String> iterator = addressmap.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();
                Object value = (Object)addressmap.get(key);
                sbs.append("'");
                sbs.append(value);
                sbs.append("'");
                if(iterator.hasNext()){
                    sbs.append(",");
                }
            }
            //对other数据进行增加
            if(other != null || other.length()>0){
                sbs.append(",");
                Iterator<String> it = other.keySet().iterator();
                while(it.hasNext()){
                    String key = it.next();
                    String value = (String)other.get(key);
                    sbs.append("'");
                    sbs.append(value);
                    sbs.append("'");
                    if (it.hasNext()) {
                        sbs.append(",");
                    }
                }
            }
            if(i == json.length()-1){
                sbs.append(")");
            }else{
                sbs.append("),");
            }
        }
        return sbs.toString();
    }
    /**
     * 获取批量sql的fileds
     * @param json
     * @return
     */
    public static String getAllnewFields(JSONArray json,JSONObject other){
//        log.info("将要进行"+json.length()+"批量sql fields");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            String nowLineValue = "";
            JSONObject map = (JSONObject)json.get(i);
            JSONObject addressmap =(JSONObject)map.get("useraddress");
            Iterator<String> iterator = addressmap.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();

                sbs.append(key);
                if (iterator.hasNext()) {
                    sbs.append(",");
                }

            }
            //对other数据进行增加
            if(other != null || other.length()>0){
                sbs.append(",");
                Iterator<String> it = other.keySet().iterator();
                while(it.hasNext()){
                    String key = it.next();
                    sbs.append(key);
                    if (it.hasNext()) {
                        sbs.append(",");
                    }
                }
            }
            sbs.append(")");
            break;
        }
        return sbs.toString();
    }

    /**
     * 获取特殊批量sql的values
     */
    public static String getAllotherValue(JSONArray json,String getIndex,JSONObject other,JSONArray arr){
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            JSONObject map = (JSONObject)json.get(i);
            JSONObject addressmap =(JSONObject)map.get(getIndex);
            Iterator<String> iterator = addressmap.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();
                Object value = (Object)addressmap.get(key);
                sbs.append("'");
                sbs.append(value);
                sbs.append("'");
                if(iterator.hasNext()){
                    sbs.append(",");
                }
            }
            //对other数据进行增加
            if(other != null || other.length()>0){
                sbs.append(",");
                Iterator<String> it = other.keySet().iterator();
                while(it.hasNext()){
                    String key = it.next();
                    String value = (String)other.get(key);
                    sbs.append("'");
                    sbs.append(value);
                    sbs.append("'");
                    if (it.hasNext()) {
                        sbs.append(",");
                    }
                }
            }
            sbs.append(",");
            String usercode = (String) arr.get(i);
            sbs.append("'"+usercode+"'");
            if(i == json.length()-1){
                sbs.append(")");
            }else{
                sbs.append("),");
            }
        }

        return sbs.toString();
    }
    /**
     * 获取特殊批量sql的fileds
     * @param json
     * @return
     */
    public static String getAllotherFields(JSONArray json,String getIndex,JSONObject other){
//        log.info("将要进行"+json.length()+"批量sql fields");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            String nowLineValue = "";
            JSONObject map = (JSONObject)json.get(i);
            JSONObject addressmap =(JSONObject)map.get(getIndex);
            Iterator<String> iterator = addressmap.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();
                sbs.append(key);
                if (iterator.hasNext()) {
                    sbs.append(",");
                }
            }
            break;
        }
        //对other数据进行增加
        if(other != null || other.length()>0){
            sbs.append(",");
            Iterator<String> it = other.keySet().iterator();
            while(it.hasNext()){
                String key = it.next();
                sbs.append(key);
                if (it.hasNext()) {
                    sbs.append(",");
                }
            }
        }
        sbs.append(",");
        sbs.append("f_comments");
        sbs.append(")");
        return sbs.toString();
    }

    /**
     * 获取足够数量的userinfo_code
     * @param
     */
    public static JSONArray getUserInfoCode(int len){
        JSONArray arr = new JSONArray();
        for (int i=0;i<len ;i++) {
            JSONObject userInfo = threadTool.getUserInfo();
            String orgids = (String) userInfo.get("orgids");
            String maxcode = "";
            try {
                maxcode = serviceNoGenerator.getNo(orgids,8);
            } catch (Exception e) {
                e.printStackTrace();
            }
            arr.put(maxcode);
        }
        return arr;
    }

    /**
     * 获取批量sql的values
     */
    public static String getAllsomeValue(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql values获取");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();
                Object value = (Object)map.get(key);
                sbs.append("'");
                sbs.append(value);
                sbs.append("'");
                if(iterator.hasNext()){
                    sbs.append(",");
                }
            }
            if(i == json.length()-1){
                sbs.append(")");
            }else{
                sbs.append("),");
            }
        }
        return sbs.toString();
    }
    /**
     * 获取批量sql的fileds
     * @param json
     * @return
     */
    public static String getAllsomFields(JSONArray json){
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            String nowLineValue = "";
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();

                sbs.append(key);
                if (iterator.hasNext()) {
                    sbs.append(",");
                }

            }
            sbs.append(")");
            break;
        }
        return sbs.toString();
    }

    public static org.json.JSONObject doLogic(String url,JSONObject param){

        //String url = "http://localhost:5011/ldap/rs/user/userLogin/%E5%AE%A2%E6%9C%8D%E7%B3%BB%E7%BB%9F";
       // String param="P44/Nc5hqnUbzq6W+6JiPvHyQGVcEe1OWfIlABTFJhgRGCHOOgnJ2TU6+9tAUhLY5JKSArI4r9ZxYNVgSckJdjb9H+hn+QQG0x2a9RdtMTV1xR1WMPVeLJMqd+HLtMZiE1FGCv8HSUzm+rN6PU3CEUkGkYVJKjlaeaOl2ua7KUE=";
       // String param="P44/Nc5hqnUbzq6W+6JiPvHyQGVcEe1OWfIlABTFJhgRGCHOOgnJ2TU6+9tAUhLY5JKSArI4r9ZxYNVgSckJdjb9H+hn+QQG0x2a9RdtMTV1xR1WMPVeLJMqd+HLtMZiE1FGCv8HSUzm+rN6PU3CEUkGkYVJKjlaeaOl2ua7KUE=";
        //String param ="gD2QsLzG4+diJQ3gVIyMejHYs66+fopNxLhWdUP4X6OooDScpffTh789wP+qRvnYl8QTb/1OfjLYxS51xB0RBkmknBcdk4YtdaKKMK5ftSlMwjzkpQSV8gHDCEmbDT4tLI0NnOuhLyV7v+wvRZXziK0Nbzb0hAFfhIWzbq8FTb8=";
        String urls = "http://localhost"+url;
        String params = param.toString();
        String result = "";
        try {
            result = SettleTools.doPost(urls,param.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        org.json.JSONObject jsonObject = new org.json.JSONObject(param.toString());
        return jsonObject;
    }

    /**
     * post请求（用于请求json格式的参数）
     * @param url
     * @param params
     * @return
     */
    public static String doPost(String url, String params) throws Exception {

        CloseableHttpClient httpclient = HttpClients.createDefault();
        org.apache.http.client.methods.HttpPost httpPost = new org.apache.http.client.methods.HttpPost(url);// 创建httpPost
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(params, charSet);
        httpPost.setEntity(entity);
        CloseableHttpResponse response = null;

        try {

            response = httpclient.execute(httpPost);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (state == HttpStatus.SC_OK) {
                HttpEntity responseEntity = response.getEntity();
                String jsonString = EntityUtils.toString(responseEntity);
                return jsonString;
            }
            else{
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                httpclient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }



}
