package com.af.timingJob;

import com.aote.rs.LogicService;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;

@Component
@EnableScheduling
@Lazy(false)
public class MeterDown {

    @Autowired
    private LogicService logicService;

//    @Scheduled(cron = "* * * * * ?")
    @Scheduled(cron = "0 50 23 28-31 * ? ")
    public void doJob(){
        if(this.isLastDay()) {
            int mon = LocalDate.now().getMonthValue();
            JSONObject value = new JSONObject();
            value.put("month", mon % 2 == 0 ? "奇数月" : "偶数月");
            value.put("begin", LocalDateTime.of(LocalDateTime.now().plusMonths(1).with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            try {
                logicService.xtSave("batchMain", new JSONObject().put("data", value).toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }else {
            System.out.println("不是最后一天");
        }
    }

    public boolean isLastDay(){
        LocalDate lastDay = LocalDate.now().with(TemporalAdjusters.lastDayOfMonth());
        return lastDay.equals( LocalDate.now());
    }
}
