package bank;

import com.aote.logic.LogicServer;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;


import java.io.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;


public class Account {
    @Autowired
    private LogicServer logicServer;
    private String path;

    static Logger log = Logger.getLogger(Account.class);
    public void getSource() {
        File files = new File(this.path);

        File[] file = files.listFiles();
        for (int i = 0; i < file.length; i++) {
            if (file[i].isFile()) {
                String invokeMethod =isLegitimacy(file[i].getAbsolutePath());
                try {
                    invokeFile(file[i], invokeMethod);
                    writeToNewPath(file[i], "bak");
                } catch (Exception e) {
                    try {
                        writeToNewPath(file[i], "error");
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    log.error("出错。。：" + e);
                }
            }
        }
    }

    private String  isLegitimacy(String path) {
        String new_path = path.replace("\\", "/");
        String filename = new_path.split("/")[(new_path.split("/").length - 1)];
        String invokeMethod = "";
        if(filename.startsWith("1007.CCB")){
            invokeMethod = "MeterAccount";
        }else if(filename.startsWith("2007.CCB") ){
            invokeMethod = "CardAccount";
        }
        return invokeMethod;
    }

    private void invokeFile(File file, String invokeMethod)
            throws Exception {
        List<String> lines = FileUtils.readLines(file, "GBK");

        for (String line : lines) {
            log.debug("读取第" + "行数据为：" + new JSONObject(line));
            this.logicServer.run(invokeMethod, new JSONObject(line));
        }

    }


    private void writeToNewPath(File file, String target) throws Exception{
        String newPath = this.path + "\\" + target + "\\" + file.getName();


        FileUtils.copyFile(file, new File(newPath));

        deleteFile(file);

    }

    public boolean deleteFile(File file) {
        if ((file.exists()) && (file.isFile())) {
            return file.delete();
        }
        return true;
    }

    private Date convertToDate(String str) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

        Date date = null;
        try {
            date = sdf.parse(str);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}
