package Imp;
import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

import com.af.plugins.DateTools;
import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;



@Transactional
public class ImportWebMeter {

    @Autowired

    public JSONObject importWebMeterFile(JSONArray obj,EntityServer entity,SqlServer sql,JSONObject info) throws Exception {
        String str = null;
        String fileName = ("表具导入异常信息.txt");
        String rootPath = null;
        String path = ImportWebMeter.class.getClassLoader().getResource("config.json").getPath();

//        if(path.indexOf("webapps/")!=-1){
//            rootPath = path.split("webapps/")[0];
//        }
        rootPath = path.split("WEB-INF/")[0];
        String filePath = rootPath + "excel/" + fileName;
        File errorfile =new File(filePath);
        if(errorfile.exists()){
            errorfile.delete();
        }
        JSONObject result=new JSONObject();
        String date = DateTools.getNow2();
        List<String> meternumber =new CopyOnWriteArrayList<>();
        //查t_gasbrand表的所有气表品牌
        JSONObject temp = new JSONObject();
        temp.put("tablename","t_gasbrand");
        temp.put("items","f_meter_brand");
        temp.put("orderitem","f_meter_brand");
        temp.put("condition"," f_orgid="+ info.getString("f_filialeid"));
        JSONArray gasbrandArray= sql.query("singleTable_OrderBy",temp);
        List<String> gasbrand=new ArrayList();
        for (int i = 0; i <gasbrandArray.length() ; i++) {
            gasbrand.add( gasbrandArray.getJSONObject(i).getString("f_meter_brand") );
        }
        int i = 0;
        int num = 0;
        for (;num<obj.length();num++) {
            obj.getJSONObject(num).getJSONObject("meterinfo").put("f_orgid",info.getString("f_orgid")) ;
            obj.getJSONObject(num).getJSONObject("meterinfo").put("f_depid",info.getString("f_depid"));
            obj.getJSONObject(num).getJSONObject("meterinfo").put("f_orgname",info.getString("f_orgname"));
            obj.getJSONObject(num).getJSONObject("meterinfo").put("f_state","待安装");
            obj.getJSONObject(num).getJSONObject("meterinfo").put("f_depname",info.getString("f_depname"));
            obj.getJSONObject(num).getJSONObject("meterinfo").put("f_operator",info.getString("f_operator"));
            obj.getJSONObject(num).getJSONObject("meterinfo").put("f_operatorid",info.getString("f_operatorid"));
            obj.getJSONObject(num).getJSONObject("meterinfo").put("f_filialeid",info.getString("f_filialeid"));
            try{
                if (!gasbrand.contains(obj.getJSONObject(num).getJSONObject("meterinfo").get("f_meter_brand"))){
                    throw new Exception();
                }
                entity.partialSave("t_meterinfo",obj.getJSONObject(num).getJSONObject("meterinfo"));
                i++;
            }catch(Exception e){
                meternumber.add(obj.getJSONObject(num).getJSONObject("meterinfo").get("f_meternumber").toString());
                //写入error文件
                if(!errorfile.exists()){
                    errorfile.createNewFile();
                }
                if (!gasbrand.contains(obj.getJSONObject(num).getJSONObject("meterinfo").get("f_meter_brand"))){
                    str=" 气表品牌"+obj.getJSONObject(num).getJSONObject("meterinfo").get("f_meter_brand")+"不存在\n";
                }else{
                    str=" 表号为"+obj.getJSONObject(num).getJSONObject("meterinfo").get("f_meternumber")+",IMEI为"+obj.getJSONObject(num).getJSONObject("meterinfo").get("f_imei")+"的表导入失败\n";
                }
                FileOutputStream outputStream=new FileOutputStream(errorfile,true);
                outputStream.write(date.getBytes());
                outputStream.write(str.getBytes());
                outputStream.close();
            }
        }
        result.put("meternum",meternumber);
        result.put("allnum",num);
        result.put("successnum",i);


        return result;
    }


}
