select f_userinfo_code,
       f_meternumber,
       f_user_name,
       hd.f_user_type,
       f_meter_classify,
       f_price_name,
       hd.f_user_id,
      '{startDate} 00:00:00' startdate,
      '{endDate} 00:00:00' enddate,
      '{startDate} - {endDate}' inputdate,
       (
            select cast(f_price as varchar) + '|'
            from t_detailprice
            where f_stairprice_id = hd.f_stairprice_id
            for xml path('')
       ) f_price,
    min(f_last_tablebase) f_last_tablebase,
    max(f_tablebase) f_tablebase,
    max(f_tablebase) - min(f_last_tablebase)  pregas,
    sd.f_surplus_fee,
    hd.f_price_id,
    hd.f_gasproperties,
    sd.f_new_price,
    sd.id
from t_handplan hd
    left join t_stairprice ts on hd.f_stairprice_id = ts.id
    left join t_surplus_detail sd on sd.id = hd.surplus_id
    left join t_user_address ad on ad.f_userinfo_id = hd.f_userinfo_id
where {condition} and f_input_date >= '{startDate} 00:00:00' and f_input_date <='{endDate} 00:00:00' and hd.f_meter_classify ='物联网表' and f_meter_state ='已抄表' and f_hand_state ='有效'
group by f_userinfo_code,
    f_meternumber,
    f_user_name,
    hd.f_user_type,
    f_meter_classify,
    hd.f_gasproperties,
    f_price_name,
    hd.f_price_id,
    hd.f_user_id,
    sd.f_surplus_fee,
    sd.f_new_price,
    sd.id,
    f_stairprice_id