// 钱铭编写
// 之前sql使用的是通用单表查询sql，由于需要加入每种品牌表具的使用户数，所以单独提取一个sql
// 如果有用户在使用，则此种品牌不能删除
select * from (
	select gb.*, gid.f_using_orgid , o.name, ISNULL(u.counts, 0) counts
	from t_gasbrand_orgid gid
	left join t_gasbrand gb on gid.f_gasbrand_id = gb.id
	LEFT JOIN (
		SELECT
			f_gasbrand_id,
			COUNT (DISTINCT f_userinfo_id) counts
		FROM
			t_userfiles
		WHERE
			f_table_state = '正常'
		GROUP BY
			f_gasbrand_id
	) u ON u.f_gasbrand_id = gb.id
	left join t_organization o on gid.f_using_orgid = o.id
) t
where {condition}
order by id desc
