SELECT
  *
FROM
  (
    SELECT
      ui.f_userinfo_id,				                            --用户编号
      ui.f_userinfo_code,				                            --用户编号
      uf.f_user_id,						                            --表编号
      uf.f_meternumber,				                            --表号
      ui.f_user_name,					                            --用户名
      a.f_address,						                            --用户地址
      uf.f_user_type,                                     --用户类型
      uf.f_gasproperties,                                 --用气性质
      uf.f_balance_amount f_balance,                      --账户结余
      --a.f_area,                                          --辖区
      a.f_slice_area,                                    --片区
      uf.f_input_date,
      a.f_street,                                        --街道
      a.f_residential_area,                              --小区
      ISNULL(uf.f_position,'未知') AS f_position,		 --表安装位置
      m1.f_signal,                                       --信号强度
      m1.f_batteryLevel,	--电压
      case
      when m1.f_valveState = '关阀' then '关阀'
      when m1.f_valveState = '开阀' then '开阀'
      else '未上报' end f_valvestate,	--阀门状态
      m1.f_software_version, --软件版本号
      gb.id AS f_gasbrand_id,	                            --品牌识别列
      gb.f_meter_brand,				                            --气表品牌
      gm.id AS f_gasmodel_id,	                            --型号识别列
      gm.f_meter_style,				                    --气表型号
      gb.f_meter_type,				                            --气表类型
      case when uf.f_table_state='正常' then '在用' else uf.f_table_state end  f_table_state,		--气表状态
      gb.f_alias,                                         --表厂别名
      uf.f_meter_base,				                            --气表底数
      isnull(s.f_collection,0) f_collection,				--累计充值金额
      isnull(h.f_oughtamount,0) f_initial_base,	--累计用气量
      isnull(h.f_oughtfee,0) AS f_total_usegas_amount, --表累购金额
      ISNULL(uf.f_valve_state,'未知') AS f_valve_state, 		--阀门状态
      ui.f_createfile_date,                               --建档日期
      ui.f_orgid,
      ui.f_depid,
      ui.f_operatorid,
      uf.f_open_date,
      uf.f_gas_date,
      uf.f_orgname,
      cast(up.f_parameter_name as varchar)
        f_parameter_name,
      case when up.f_parameter_name is null then '未标记'
      else '已标记' end f_parameter_state
    --case when (m1.f_signal<=-101 or m1.f_batterylevel<4.00 or m1.f_magneticinterference=1 or m1.f_cycleshutvalue=1
    --or m1.f_overcurrentprotection=1 or m1.f_leakageflag=1 or m1.f_splitalarm=1 or m1.f_xtipllstopflag=1) then '异常'
    -- else
    --case when (select count(*) c from t_exception where f_meternumber = uf.f_meternumber
    --and f_is_read = 0) = 0 then '正常' else '异常' end
    -- end f_userfiles_state
    FROM
      t_userfiles uf
      LEFT JOIN t_userinfo ui ON (ui.f_userinfo_id= uf.f_userinfo_id)
      LEFT JOIN t_gasbrand gb ON (uf.f_gasbrand_id= gb.id)
      LEFT JOIN t_gasmodel gm ON (uf.f_gasmodel_id= gm.id)
      left join t_user_address a on a.f_userinfo_id=ui.f_userinfo_id
      left join (
                  select f_meternumber,sum(f_oughtamount) f_oughtamount,sum(f_oughtfee) f_oughtfee
                  from t_handplan where f_meter_state='已抄表' group by f_meternumber
                ) h on  uf.f_meternumber = h.f_meternumber
      left join (
                  select f_meternumber,sum(f_collection) f_collection from t_sellinggas where f_charge_state='有效'
                  group by f_meternumber
                ) s on uf.f_meternumber=s.f_meternumber
      left join (select f_meternumber,max(id) maxid from t_meteread group by f_meternumber) m on uf.f_meternumber=m.f_meternumber
      left join t_meteread m1 on m.maxid=m1.id
      left join (
                  select f_user_id,f_meternumber,
                    (select f_parameter_name+',' from t_userparameter
                    where f_parameter_state='待处理' and f_meternumber=u.f_meternumber for xml path('') )  f_parameter_name
                  from t_userparameter u
                  group by f_meternumber,f_user_id
                )  up on uf.f_meternumber = up.f_meternumber
    WHERE uf.f_meter_classify='物联网表'
  ) t_userfiles
where {condition}
ORDER BY
f_user_id DESC
