SELECT
    *
FROM
    (
        SELECT
            DISTINCT
            ui.f_userinfo_id,				                            --用户编号
            ui.f_userinfo_code,				                            --用户编号
            uf.f_user_id,						                            --表编号
            uf.f_userfiles_id,
            uf.f_meternumber,				                            --表号
            ui.f_user_name,					                            --用户名
            a.f_address,						                            --用户地址
            uf.f_user_type,                                     --用户类型
            uf.f_gasproperties,                                 --用气性质
            m1.f_insert_date,
            (case when m1.f_valveState = 1 then '关阀' when m1.f_valveState = 0 then '开阀' else '未上报' end) f_valvestate,	--阀门状态
            gb.id AS f_gasbrand_id,	                            --品牌识别列
            gb.f_meter_brand,				                            --气表品牌
            gm.id AS f_gasmodel_id,	                            --型号识别列
            gm.f_meter_style,				                    --气表型号
            gb.f_meter_type,				                            --气表类型
            case when uf.f_table_state='正常' then '在用' else uf.f_table_state end  f_table_state,		--气表状态
            gb.f_alias,                                         --表厂别名
            ui.f_orgid,
            uf.f_gas_date,
            uf.f_orgname,
            uf.f_depid,
            uf.f_operatorid,
            case when (m1.f_signal<=-101 or m1.f_batterylevel<4.00 or m1.f_magneticinterference=1 or m1.f_cycleshutvalue=1
                or m1.f_overcurrentprotection=1 or m1.f_leakageflag=1 or m1.f_splitalarm=1 or m1.f_xtipllstopflag=1) then '异常'
                 else
                     case when (select count(*) c from t_exception where f_meternumber = uf.f_meternumber
                                                                     and f_is_read = 0) = 0 then '正常' else '异常' end
                end f_userfiles_state
        FROM
            t_userfiles uf
                LEFT JOIN t_user_address a on uf.f_useraddress_id=a.id
                LEFT JOIN t_userinfo ui ON (ui.f_userinfo_id= uf.f_userinfo_id)
                LEFT JOIN t_gasbrand gb ON (uf.f_gasbrand_id= gb.id)
                LEFT JOIN t_gasmodel gm ON (uf.f_gasmodel_id= gm.id)
                left join (select f_meternumber,max(id) maxid from t_meteread group by f_meternumber) m on uf.f_meternumber=m.f_meternumber
                left join t_meteread m1 on m.maxid=m1.id
        WHERE uf.f_table_state ='正常' and ui.f_user_state='正常'
    ) t_userfiles
WHERE {condition}
ORDER BY
    f_userfiles_id DESC

