SELECT
    u.*,
    i.id,
    i.cmdid,
    i.f_inputtor,            --指令下发者
    (case when (i.f_receive_state='0' or  i.f_receive_state is NULL) then '未执行'
			when i.f_receive_state='1' then '执行中'
			when i.f_receive_state='2'  then '成功'
			when i.f_receive_state='3'  then '失败'
			else i.f_receive_state
       end) f_receive_state, --上表状态
    i.f_manufacturers,       --气表厂家
    i.f_instruct_type,       --指令类型
    i.f_instruct_state,      --指令状态
    i.f_instruct_date,       --指令生成时间
    i.f_instruct_content,    --指令内容
    i.f_meternumber,         --表号
    i.f_instruct_title,      --指令副标题
    substring(substring(f_instruct_content,CHARINDEX('cmdparm',f_instruct_content)+10,100),0,CHARINDEX('",',substring(f_instruct_content,CHARINDEX('cmdparm',f_instruct_content)+10,100)))as f_cmdparam
FROM t_instruct i
LEFT JOIN
( select
       gm.f_meter_style,
	   u.f_userinfo_code,
       uf.f_price_id,             --气价编号
       u.f_user_state,           --用户状态
       u.f_user_name,            --用户姓名
       uf.f_balance_amount f_balance,          	 --用户账户结余
       a.f_residential_area, 	 --小区
       a.f_address,              --地址
       a.f_room,             	 --门牌号
       a.f_street,  			 --街道
       a.f_unit,  			--单元号
       a.f_building,  			 --楼号
       a.f_floor,  			--楼层
       u.f_credentials,			 --证件类型
       u.f_idnumber,             --证件号码
       u.f_user_phone,   		 --用户电话
       uf.f_user_type,            --用户类型
       uf.f_gasproperties,		 --用气性质
       u.f_createfile_date,      --建档日期
       uf.f_user_id,              --用户表编号
       u.f_userinfo_id,          --用户编号
       uf.f_meter_classify f_meter_type,       --气表分类
       uf.f_position,               --表安装位置
       uf.f_card_id,                --卡号
       uf.f_aroundmeter,            --左 右 表
       uf.f_times,                  --写卡次数
       uf.f_whether_hairpin,        --是否发卡
       uf.f_remanent_gas,         --剩余补气量
       uf.f_card_password,        --卡密码
       uf.f_initial_base,	     --表初始底数
       uf.f_open_date,           --安装时间
       uf.f_table_state,           --表状态
        uf.f_orgid,                --分公司
	   uf.f_depid,
	   uf.f_operatorid
from t_userfiles uf left join
t_userinfo u on uf.f_userinfo_id=u.f_userinfo_id
LEFT join t_user_address a on a.f_userinfo_id=uf.f_userinfo_id
left join t_gasmodel gm on uf.f_gasmodel_id = gm.id
) u
on i.f_user_id = u.f_user_id
where  {condition}
order by f_instruct_date DESC
