/*
 * Decompiled with CFR 0.152.
 */
package bank;

import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BankFileDealAK {
    @Autowired
    private LogicServer logicServer;
    static Logger log = Logger.getLogger(EntityServer.class);
    private String path;
    private String path1;

    public String getPath() {
        return this.path;
    }

    public String getPath1() {
        return this.path1;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPath1(String path1) {
        this.path1 = path1;
    }

    public void getSource() {
        File files = new File(this.path);
        File[] file = files.listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (!file[i].isFile() || !this.isLegitimacy(file[i].getAbsolutePath())) continue;
            try {
                this.dealFile(file[i]);
                this.writeToNewPath(file[i], "bak");
                continue;
            }
            catch (Exception e) {
                this.writeToNewPath(file[i], "error");
                log.debug((Object)("\u51fa\u9519\u3002\u3002\uff1a" + e));
            }
        }
    }

    private boolean isLegitimacy(String path) {
        String new_path = path.replace("\\", "/");
        String filename = new_path.split("/")[new_path.split("/").length - 1];
        return filename.startsWith("2004");
    }

    private void dealFile(File file) throws Exception {
        String str = null;
        BufferedReader bf = null;
        bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
        int i = 0;
        while ((str = bf.readLine()) != null) {
            log.debug((Object)("\u8bfb\u53d6\u7b2c" + i + "\u884c\u6570\u636e\u4e3a\uff1a" + new JSONObject(str)));
            this.logicServer.run("bankFileDealAK", new JSONObject(str));
            ++i;
        }
        bf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToNewPath(File file, String target) {
        String newpath = this.path1 + "\\" + target + "\\" + file.getName();
        BufferedReader read = null;
        OutputStreamWriter write = null;
        try {
            String temp;
            read = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
            write = new FileWriter(new File(newpath), true);
            while ((temp = read.readLine()) != null) {
                write.write(temp + "\r\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                read.close();
                write.close();
                this.deleteFile(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean deleteFile(File file) {
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return true;
    }

    private Date convertToDate(String str) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date date = null;
        try {
            date = sdf.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }
}

