select * from
(
   select  
    d.version,            -- 表版本，更新使用
    d.f_userinfo_code,
		d.userinfo_version,	  --户版本	
		d.f_user_name,	      --用户姓名
		d.f_address,		  --用户地址	
		d.f_meter_classify,	  -- 气表分类	
		d.f_residential_area,
	    d.f_price_type,		  --气价类型
		d.f_price_name,		  --气价名称
		d.f_user_id,		  --气表编号
		d.f_userinfo_id,	  --分公司
		d.f_meter_type,		--气表类型
		d.f_price_id,			--气价编号
		d.f_hand_date,			--下发日期
		d.f_filialeids,
		d.f_filiale,			--分公司
		d.f_outlets,			--营业忘网点
		case when d.inputtor is null then d.f_inputtor else d.inputtor end as f_inputtor,		--抄表员		
		d.f_user_type,			--用户类型（自动下账时，产生收费记录时使用）
		d.f_gasproperties,      --用气性质（自动下账时，产生收费记录时使用）
		d.f_meter_brand,        --气表品牌（自动下账时，产生收费记录时使用）
		d.f_meter_style,        --气表型号（自动下账时，产生收费记录时使用）
		d.f_meternumber,         --表号（自动下账时，产生收费记录时使用）
		case when (d.f_meternumber = '' or d.f_meternumber is null) then '无表号' else '有表号' end as  meternumber_state,  
		d.f_fire_state,
		d.f_remanent_gas,        -- 剩余补气量
		d.h_user_id,				--气表编号
		d.id,						--抄表id		
		d.f_sell_id,			--对应的收费记录
		d.f_tablebase,			--本期指数
		d.f_whether_pay,		--是否缴费
		d.f_oughtamount,		--应交气量	
		d.f_oughtfee,
		
		{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(d.f_meter_source, '手动录入') f_meter_source,
		{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(d.f_issued_state, '手动下发') f_issued_state,
		{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(d.f_meter_state,'未下发') f_meter_state
from (
  select 
        version,
        u.f_userinfo_code,
        u.userinfo_version,
        u.f_meter_type,     	
        u.f_meter_classify,			
        u.f_user_name,			
        u.f_address,				
        u.f_residential_area,
        f_meter_base,					
        u.f_user_id,
        u.f_price_type,			
		u.f_price_name,			
        u.f_userinfo_id,		
        u.f_price_id,			
        u.f_inputtor,				
        u.f_user_type,			
        u.f_gasproperties,      
        u.f_meter_brand,        
        u.f_meter_style,        
        u.f_meternumber,        
        u.f_fire_state,
        u.f_remanent_gas,       
        u.f_initial_base,
        u.f_filialeids,
        u.f_filiale,			
        u.f_outlets,
        h.f_user_id h_user_id,		
        f_last_tablebase,
        h.id id,	
        f_tablebase,			
        f_whether_pay,
        f_sell_id,		
        f_oughtamount,		
        f_oughtfee,			
        f_hand_date,
        h.f_meter_state,			
        h.f_inputtor inputtor,
        f_meter_source,
        f_issued_state,
        f_surplus_gas,
        f_haircut_gas
   from 
   (
      select * from ({${sql.call($VUserTable$,{})}) t_$} where f_table_state = '正常' and f_user_state = '正常'
  ) u
  left join
  (
   select * from t_handplan
   where f_hand_date<{ entity.findDialect() == $SqlServer$: $'{startDate} 00:00:00'$,$to_date('{startDate} 00:00:00','yyyy-mm-dd hh24:mi:ss')$}
      and f_meter_state != '冲正' and id not in (
      	select f_correct_id from t_correcthandplan where f_correct_state = '有效')
   ) h on h.f_user_id=u.f_user_id 
) d
) u
where  f_meter_state = '未抄表' and {condition}
order by f_user_id