select
	f_user_id,
	f_meternumber,
	f_user_name,
	f_balance,
	f_curbalance,
	f_hand_date,
	f_last_tablebase,
	f_tablebase,
	f_oughtamount,
	f_oughtfee,
	c.f_hand_id,
	c.f_price1,
	c.f_price2,
	c.f_price3,
	c.f_price4,
	c.f_gas1,
	c.f_gas2,
	c.f_gas3,
	c.f_gas4,
	c.f_money1,
	c.f_money2,
	c.f_money3,
	c.f_money4,
	replace(c.f_price1+' '+c.f_price2+' '+c.f_price3+' '+c.f_price4+' ','0.00 ','') f_price,
	case when c.f_gas1+c.f_gas2+c.f_gas3+c.f_gas4!= f_oughtamount then '气量异常' else '正常' end f_gas_state,
	case when c.f_money1+c.f_money2+c.f_money3+c.f_money4!= f_oughtfee then '金额异常' else '正常' end f_money_state
from t_handplan h left join (
	select
		f_hand_id,
		cast(sum(f_price1) as varchar) f_price1,
		cast(sum(f_price2) as varchar) f_price2,
		cast(sum(f_price3) as varchar) f_price3,
		cast(sum(f_price4) as varchar) f_price4,
		sum(f_gas1) f_gas1,
		sum(f_gas2) f_gas2,
		sum(f_gas3) f_gas3,
		sum(f_gas4) f_gas4,
		sum(f_money1) f_money1,
		sum(f_money2) f_money2,
		sum(f_money3) f_money3,
		sum(f_money4) f_money4
from (
		select
		 f_hand_id,
		 case when f_price_name='固定气价' or f_price_name='阶梯1' then f_price else 0 end f_price1,
		 case when f_price_name='阶梯2' then f_price else 0 end f_price2,
		 case when f_price_name='阶梯3' then f_price else 0 end f_price3,
		 case when f_price_name='阶梯4' then f_price else 0 end f_price4,
		 case when f_price_name='固定气价' or f_price_name='阶梯1' then f_gas else 0 end f_gas1,
		 case when f_price_name='阶梯2' then f_gas else 0 end f_gas2,
		 case when f_price_name='阶梯3' then f_gas else 0 end f_gas3,
		 case when f_price_name='阶梯4' then f_gas else 0 end f_gas4,
		 case when f_price_name='固定气价' or f_price_name='阶梯1' then f_money else 0 end f_money1,
		 case when f_price_name='阶梯2' then f_money else 0 end f_money2,
		 case when f_price_name='阶梯3' then f_money else 0 end f_money3,
		 case when f_price_name='阶梯4' then f_money else 0 end f_money4
		from t_chargeprice
	) hc group by f_hand_id
) c on h.id = c.f_hand_id
WHERE {condition}
order by f_hand_date desc