select
	 u4.f_userinfo_id,
	 u4.f_userinfo_code,
	 u4.f_user_name,
	 u4.f_user_phone,
	 u3.f_address,
   u2.f_user_type,
   u2.f_user_id,
   u1.f_source,
   u1.f_meter_type,
   u2.f_price_id,
	 u2.f_meternumber,
	 u2.f_filialeids,
	 ROUND(u1.pregas,0) pregas,
	sp.f_price_name
from (
	select
		f_user_id,
		f_userinfo_id,
		f_meter_type,
		SUM(f_pregas) pregas,
		'收费' f_source
	from t_sellinggas
	where
		f_charge_state<>'无效' and f_charge_type in  ('发卡售气','卡表收费')
			and f_delivery_date between '{startDate} 00:00:00' and  '{endDate} 23:59:59'
			and f_surplus_detail_id is null
			group by f_user_id,f_userinfo_id,f_meter_type
	union ALL
	select
		f_user_id,
		f_userinfo_id,
		f_meter_classify f_meter_type,
		ROUND(SUM(f_oughtamount),0) pregas,
		'抄表' f_source
	from t_handplan
	where f_input_date between '{startDate} 00:00:00' and  '{endDate} 23:59:59'
	and f_meter_state='已抄表' and f_surplus_detail_id is null
	group by f_user_id,f_userinfo_id,f_meter_classify
) u1
	left join t_userfiles u2 on u1.f_user_id=u2.f_user_id
	left join t_user_address u3 on u2.f_useraddress_id=u3.id
  LEFT JOIN
  (select * from  t_stairprice
  where getdate()>=f_perform_date and getdate()<=f_end_date
        and f_state = '有效'
  ) sp on u2.f_price_id = sp.f_price_id and  u2.f_filialeids = sp.f_filialeids
	left join t_userinfo u4 on u3.f_userinfo_id=u4.f_userinfo_id

where {condition} and  u1.pregas >0

order by f_userinfo_code desc

