--异常查询
select
 f_insert_date,
 sum(zhengchang_usernumber) zhengchang_usernumber, --正常户数
 sum(usernumber) usernumber,	--异常户数
 sum(error_type1) error_type1,	--抄表异常数
 sum(error_type2) error_type2,	--电压低数
 sum(error_type3) error_type3,	--信号质量差数
 sum(error_type4) error_type4,	--磁干扰数
 sum(error_type5) error_type5,	--过流保护关阀数
 Convert(decimal(18,2),(sum(usernumber)/(sum(zhengchang_usernumber)*1.00))*100) error_bv
from (
		select
			CONVERT (VARCHAR (11),every_time,23) f_insert_date,
			(select count(*) from t_userfiles where f_gas_date<=every_time and f_table_state='正常' and {condition}) zhengchang_usernumber,
			(select count(*) from t_userfiles where f_gas_date<=every_time and f_table_state='停用' and {condition}) tingyong_usernumber,
		   0 usernumber,
		   0 error_type1,
		   0 error_type2,
		   0 error_type3,
		   0 error_type4,
		   0 error_type5
		from (
			SELECT
				CONVERT (VARCHAR (100),DATEADD(dd,number,'{startDate}'),23)+' 23:59:59' AS every_time,
				CONVERT (VARCHAR (100),DATEADD(dd,number,'{startDate}'),23)+' 00:00:00' AS every_start_time
			FROM
				master..spt_values n
			WHERE
				n.type = 'p' AND DATEDIFF(MI,DATEADD(dd,number,'{startDate}'),'{endDate}') >= 0
		) s2
		union all
		 select
		   f_insert_date,
		   0 zhengchang_usernumber,
		   0 tingyong_usernumber,
		   count(distinct f_meternumber) usernumber,
		   sum(error_type1) error_type1,
		   sum(error_type2) error_type2,
		   sum(error_type3) error_type3,
		   sum(error_type4) error_type4,
		   sum(error_type5) error_type5
		 from(
			select
				e.*,
				case when  f_error_type = '抄表异常' then 1 else 0 end error_type1,
				case when  f_error_type = '电压低' then 1 else 0 end error_type2,
				case when  f_error_type = '信号质量差' then 1 else 0 end error_type3,
				case when  f_error_type = '磁干扰' then 1 else 0 end error_type4,
				case when  f_error_type = '过流保护关阀' then 1 else 0 end error_type5
			from (
				select
					convert(varchar(21),f_insert_date,23) f_insert_date,f_error_type,e.f_meternumber,e.f_orgstr
				from t_exception e left join t_userfiles u on e.f_meternumber = u.f_meternumber
				where f_insert_date>='{startDate}' and f_insert_date<='{endDate}'
				group by convert(varchar(21),f_insert_date,23),f_error_type,e.f_meternumber,e.f_orgstr
			) e where {condition}
		) s
		group by s.f_insert_date
) s group by f_insert_date
order by f_insert_date