select  * from(
	select
		s.f_meternumber, --表钢号
		s.f_user_name,		--用户名称
		s.f_address,		--地址
		s.f_user_type,		--用户类型
		s.f_gasproperties,	--用气性质
		s.f_gasproperties2,	--用气属性
		s.f_orgstr,			--分公司
		h1.f_balance,		--期初余额(元)
		h1.f_last_tablebase,--上期读数
		h2.f_tablebase,		--本期读数
		s.f_oughtamount,	--用气气量(m²)
		s.f_oughtfee,		--用气金额(元)
		Convert(decimal(18,2),s.f_oughtfee/(case when s.f_oughtamount = 0 then 1 else s.f_oughtamount end)) f_avg_price,--平均单价(元/m²)
		h2.f_curbalance,	--期末结余(元)
		convert(varchar(11),h1.f_hand_date,23) f_last_hand_date,
		convert(varchar(11),h2.f_hand_date,23) f_end_hand_date
		--convert(varchar(11),h1.f_hand_date,23)+'至'+convert(varchar(11),h2.f_hand_date,23) f_hand_date,--用气区间
	from(
		select
		  h.f_meternumber,
		  h.f_user_id,
		  u.f_user_name,
		  u.f_address,
		  uf.f_user_type,
		  uf.f_gasproperties,
		  uf.f_gasproperties2,
		  uf.f_orgstr,
		  uf.f_filiale,
          uf.f_outlets,
		  min(id) minid,
		  max(id) maxid,
		  sum(f_oughtamount) f_oughtamount,
		  sum(f_oughtfee) f_oughtfee
		from t_handplan h
		left join t_userfiles uf on h.f_user_id=uf.f_user_id
		left join t_userinfo u on uf.f_userinfo_id = u.f_userinfo_id
	    where {condition}
	  group by h.f_meternumber,
		  h.f_user_id,
		  u.f_user_name,
		  u.f_address,
		  uf.f_user_type,
		  uf.f_gasproperties,
		  uf.f_gasproperties2,
		  uf.f_orgstr,
		  uf.f_filiale,
          uf.f_outlets
	) s left join t_handplan h1 on s.minid=h1.id
		left join t_handplan h2 on s.maxid=h2.id
) s
order by f_meternumber desc
