package product;

import com.af.plugins.DateTools;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Test {

    public static void main(String[] args) throws Exception{

        System.out.println(getStairStartDate("08-17",  1, "2019-08-15 11:46:37"));
    }

    public static String getStairStartDate(String start, Object cycle, String handdate)
            throws Exception {
        // 参数验证
        if ("".equals(start) || start == null) {
            throw new Exception("您所传的阶梯开始时间不能为空!!");
        }
        if (cycle == null) {
            throw new Exception("您所传的阶梯周期不能为空!!");
        }
        if ("".equals(handdate) || handdate == null) {
            throw new Exception("您所传的抄表单下发时间不能为空!!");
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar now = Calendar.getInstance();
        String[] str = start.split("-");
        // 开始月份
        int beginMonth = Integer.parseInt(str[0]);
        // 当前月份
        int nowMonth = getMonth(handdate);

        if (isLastYear(handdate)) {
            now.set(Calendar.YEAR, now.get(Calendar.YEAR) - 1);
        } else {
            now.set(Calendar.YEAR, now.get(Calendar.YEAR));
        }

        now.set(Calendar.DAY_OF_MONTH, Integer.parseInt(str[1]));


        // 计算月份
        int a = (nowMonth + (12 - beginMonth))%((int)cycle);
        System.out.println("取余操作" + a);
        int month = 0;
        if (isLowerDay(Integer.parseInt(str[1]))) {
            month = a == 0 ? a - (int)cycle : 0 - a;
        } else {
            month = 0 - a;
        }
        System.out.println("计算月份" + month);
        now.add(Calendar.MONTH, month);

        return format.format(now.getTime());
    }

    public static int getMonth(String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date getDate = format.parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(getDate);
        return cal.get(Calendar.MONTH) + 1;
    }

    public static boolean isLowerDay(int d) {
        Calendar now = Calendar.getInstance();
        int day = now.get(Calendar.DATE);
        return day - d < 0;
    }

    private static boolean isLastYear(String date) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date getDate = format.parse(date);

        Calendar cal = Calendar.getInstance();
        // 当前年份
        int currentYear = cal.get(Calendar.YEAR);
        // 获取传入日期的年份
        cal.setTime(getDate);
        int year = cal.get(Calendar.YEAR);
        return year < currentYear;
    }

}
