SELECT
    isnull(t2.numday, 0) numday,
    isnull(t3.unnumday,0) unnumday,
    t1.*
FROM
    (
        SELECT
            COUNT (f_filialeids) num,
            f_filiale,
            f_filialeids
        FROM
            (
                SELECT
                    f_userinfo_code,
                    f_user_name,
                    f_user_phone,
                    p.f_userinfo_id,
                    f_state,
                    a.f_address,
                    i.f_filialeids,
                    i.f_filiale
                FROM
                    t_userproperties p
                        LEFT JOIN t_userinfo i ON p.f_userinfo_id = i.f_userinfo_id
                        LEFT JOIN t_user_address a ON a.f_userinfo_id = i.f_userinfo_id
                WHERE
                        f_parameter_key = 'blackList'
                  AND f_state = '有效'
            ) t
        WHERE
            {condition}
        GROUP BY
            f_filialeids,
            f_filiale
    ) t1
        LEFT JOIN (
        SELECT
            COUNT (f_filialeids) numday,
            f_filiale,
            f_filialeids
        FROM
            (
                SELECT
                    f_userinfo_code,
                    f_user_name,
                    f_user_phone,
                    p.f_userinfo_id,
                    f_state,
                    a.f_address,
                    i.f_filialeids,
                    i.f_filiale
                FROM
                    t_userproperties p
                        LEFT JOIN t_userinfo i ON p.f_userinfo_id = i.f_userinfo_id
                        LEFT JOIN t_user_address a ON a.f_userinfo_id = i.f_userinfo_id
                WHERE
                        f_parameter_key = 'blackList'
                  AND f_state = '有效'
                {
                    search_date == $$:
                    $ AND p.f_parameter_value >= CONVERT (VARCHAR(30), getdate(), 23) + ' 00:00:00' $,
                    $ AND p.f_parameter_value >= '{search_date}' + ' 00:00:00'
                      and p.f_parameter_value <= '{search_date}' + ' 23:59:59'
                    $
                }
            ) t
        WHERE
            {condition}
        GROUP BY
            f_filialeids,
            f_filiale
    ) t2 ON t1.f_filialeids = t2.f_filialeids
        LEFT JOIN (
        SELECT
            COUNT (f_filialeids) unnumday,
            f_filiale,
            f_filialeids
        FROM
            (
                SELECT
                    f_userinfo_code,
                    f_user_name,
                    f_user_phone,
                    p.f_userinfo_id,
                    f_state,
                    a.f_address,
                    i.f_filialeids,
                    i.f_filiale
                FROM
                    t_userproperties p
                        LEFT JOIN t_userinfo i ON p.f_userinfo_id = i.f_userinfo_id
                        LEFT JOIN t_user_address a ON a.f_userinfo_id = i.f_userinfo_id
                WHERE
                        f_parameter_key = 'blackList'
                  AND f_state = '无效'
                    {
                    search_date == $$:
                    $ AND p.f_parameter_value >= CONVERT (VARCHAR(30), getdate(), 23) + ' 00:00:00' $,
                    $ AND p.f_parameter_value >= '{search_date}' + ' 00:00:00'
                      and p.f_parameter_value <= '{search_date}' + ' 23:59:59'
                    $
                }
            ) t
        WHERE
            {condition}
        GROUP BY
            f_filialeids,
            f_filiale
    ) t3 ON t1.f_filialeids = t3.f_filialeids