/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Path(value="route")
@Component
public class HanWeiRoute {
    static Logger log = Logger.getLogger(HanWeiRoute.class);
    static String AUTH_URL;
    static String LOGIN_URL;
    static String VUE_URL;
    static String USER_URL;

    @GET
    @Path(value="{app}")
    public Response route(@Context HttpServletRequest request, @PathParam(value="app") String vue, @QueryParam(value="ticket") String token) throws Exception {
        String[] pairs;
        Object ticket = null;
        String qs = "";
        for (String pair : pairs = request.getQueryString().split("&")) {
            int idx = pair.indexOf("=");
            String attr = pair.substring(0, idx);
            if (attr.equals("ticket")) continue;
            qs = qs + "&" + attr + "=" + pair.substring(idx + 1);
        }
        if (token == null) {
            return Response.temporaryRedirect((URI)new URI(LOGIN_URL)).build();
        }
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet hg = new HttpGet(AUTH_URL + token);
        HttpResponse response = client.execute((HttpUriRequest)hg);
        if (response.getStatusLine().getStatusCode() == 200) {
            if (EntityUtils.toString((HttpEntity)response.getEntity()).contains("\"Result\":true")) {
                request.getSession().setAttribute("ticket", (Object)token);
                String userId = this.getUserId(token);
                if (userId != null) {
                    return Response.temporaryRedirect((URI)new URI(VUE_URL + vue + ".html?f_user_id=" + userId + qs)).build();
                }
                return Response.temporaryRedirect((URI)new URI(LOGIN_URL)).build();
            }
            return Response.temporaryRedirect((URI)new URI(LOGIN_URL)).build();
        }
        return Response.temporaryRedirect((URI)new URI(LOGIN_URL)).build();
    }

    private String getUserId(String ticket) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet hg = new HttpGet(USER_URL + ticket);
        HttpResponse response = client.execute((HttpUriRequest)hg);
        if (response.getStatusLine().getStatusCode() == 200) {
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            JSONObject jo = new JSONObject(result);
            JSONObject KeyValue = new JSONObject(jo.getString("KeyValue"));
            JSONObject user = new JSONObject(KeyValue.getString("user"));
            return user.getString("usercode");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        Properties prop = new Properties();
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("hanwei.properties");
            prop.load(is);
            AUTH_URL = prop.getProperty("authUrl");
            USER_URL = prop.getProperty("userUrl");
            LOGIN_URL = prop.getProperty("loginUrl");
            VUE_URL = prop.getProperty("vueUrl");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

