package utils;


import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class EticketJsonTools {
	public static JSONObject readJsonFile(String fileName) {
		BufferedReader reader = null;
		StringBuilder laststr = new StringBuilder();
		try {
			InputStream input = EticketJsonTools.class
					.getResourceAsStream("/" + fileName);
			InputStreamReader inputStreamReader = new InputStreamReader(input,
					StandardCharsets.UTF_8);
			reader = new BufferedReader(inputStreamReader);
			String tempString;
			while ((tempString = reader.readLine()) != null) {
				laststr.append(tempString);
			}
			reader.close();
			return new JSONObject(laststr.toString());
		} catch (IOException e) {
			throw new RuntimeException(e);
		} finally {
			if (reader != null) {
				try {
					reader.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	public static void main(String[] args) {
		JSONObject json=new JSONObject();
		json= EticketJsonTools.readJsonFile("Eticket.json");
		System.out.println(json);
	}
}
