package com.aote.rs;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;


@Path("route")
@Component
public class HanWeiRoute {

	static Logger log = Logger.getLogger(HanWeiRoute.class);
	static String AUTH_URL;
	static String LOGIN_URL;
	static String VUE_URL;
	static String USER_URL;

	@GET
	@Path("{app}")
	public Response  route(@Context HttpServletRequest request, @PathParam("app") String vue, @QueryParam("ticket") String token) throws Exception {
		String ticket = null; //(String) request.getSession().getAttribute("ticket");
		String qs = "";
	    String[] pairs = request.getQueryString().split("&");
	    for (String pair : pairs) {
	        int idx = pair.indexOf("=");
	        String attr = pair.substring(0, idx);
	        if(!attr.equals("ticket"))
	        	qs += "&" + attr + "=" +  pair.substring(idx + 1);
	    }
//		if(ticket != null) {
//			ע���¼�û�
//			String userId = getUserId(ticket);
//			if(userId != null) {
//				return Response.temporaryRedirect(new URI(VUE_URL + vue + ".html?f_user_id=" + userId + qs)).build();
//			}
//			else
//				return Response.temporaryRedirect(new URI(LOGIN_URL)).build();
//		}
//		else {
			//重新登录
			if(token == null)
				return Response.temporaryRedirect(new URI(LOGIN_URL)).build();
			else {
				HttpClient client = new DefaultHttpClient();
				HttpGet hg = new HttpGet(AUTH_URL + token);
				org.apache.http.HttpResponse response = client.execute(hg);
				if(response.getStatusLine().getStatusCode() == 200) {
					//{"ErrorMessage":null,"KeyValue":null,"Result":true}
					if(EntityUtils.toString(response.getEntity()).contains("\"Result\":true")) {
						request.getSession().setAttribute("ticket", token);
						String userId = getUserId(token);
						if(userId != null)
							return Response.temporaryRedirect(new URI(VUE_URL + vue + ".html?f_user_id=" + userId + qs)).build();
						else
							return Response.temporaryRedirect(new URI(LOGIN_URL)).build();
					} else {
						return Response.temporaryRedirect(new URI(LOGIN_URL)).build();
					}
				} else {
					return Response.temporaryRedirect(new URI(LOGIN_URL)).build();
				}
			}
		//}
	}

	private String getUserId(String ticket) throws Exception {
		HttpClient client = new DefaultHttpClient();
		HttpGet hg = new HttpGet(USER_URL + ticket);
		org.apache.http.HttpResponse response = client.execute(hg);
		if(response.getStatusLine().getStatusCode() == 200) {
			//{"ErrorMessage":null,"KeyValue":null,"Result":true}
			String result = EntityUtils.toString(response.getEntity(), "UTF-8");

			JSONObject jo = new JSONObject(result);
			JSONObject KeyValue = new JSONObject(jo.getString("KeyValue"));
			JSONObject user = new JSONObject(KeyValue.getString("user"));
//			JSONObject jo = new JSONObject(result.replace("\"{", "{").replace("}\"", "}").replace("\\\"", "\""));
			return user.getString("usercode");
		}
		else
			return null;
	}

	@PostConstruct
	public void init() {
		Properties  prop = new Properties();
		InputStream is = null;
		try {
			is = getClass().getClassLoader().getResourceAsStream("hanwei.properties");
			prop.load(is);
			AUTH_URL = prop.getProperty("authUrl");
			USER_URL = prop.getProperty("userUrl");
			LOGIN_URL = prop.getProperty("loginUrl");
			VUE_URL = prop.getProperty("vueUrl");
		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			if(is != null)
				try {
					is.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
		}
	}
}
