select * from (
select 
	F_SERIAL_ID,SELL_USER_ID,F_COLLECTION,F_USER_NAME,F_DELIVERY_DATE,F_CHARGE_STATE,F_BANK_NAME,
	F_ALIAS,F_TOTAL_CHARGE,BANK_USER_ID,F_TRADE_NUMBER,F_TRADE_DATE,
	(case 
		when s.f_delivery_date is null then b.f_trade_date
		when b.f_trade_date is null then s.f_delivery_date
		else s.f_delivery_date
	 end) delivery_date,
	(CASE
		 WHEN s.sell_user_id  = b.bank_user_id AND s.f_collection = b.f_total_charge  THEN '对账成功'						
		 WHEN s.sell_user_id  = b.bank_user_id AND s.f_collection != b.f_total_charge THEN '对账金额错误'
		 WHEN b.f_trade_number IS NULL THEN '燃气方单方面账单' 
		 WHEN s.f_serial_id IS NULL  THEN '翼支付方单方面账单' 
		 WHEN s.sell_user_id  != b.bank_user_id THEN '用户id不匹配' 
		 ELSE '匹配无效'
	 END) msg

from 
	(SELECT f_serial_id,f_user_id sell_user_id,f_collection,f_user_name,f_delivery_date,f_charge_state 
from t_sellinggas where f_charge_state = '有效' and f_payment='银行支付') s
full outer join 
(select f_bank_name,f_alias,f_total_charge,f_user_id bank_user_id,f_trade_number,f_trade_date
from t_bank_payment) b
on s.f_serial_id = b.f_trade_number
) t 
where {condition}
order by {orderitem}