select  * from
(
   select  
        d.version,            -- 表版本，更新使用 
		d.userinfo_version,	  --户版本	
		d.f_user_name,	      --用户姓名
		d.f_balance,		  --账户结余
		d.f_address,		  --用户地址
		d.f_meter_base,		  --表底数	
		case  
		    when d.f_gas_date>{ entity.findDialect() == $SqlServer$: $DATEADD(s,-1,DATEADD(mm, DATEDIFF(m,0,GETDATE()), 0))$,$trunc(sysdate, 'mm')-1/24/60/60$} and h1.f_user_id is null
		    then d.f_initial_base
		    when d.changemeterdate is not null and d.changemeterdate>{ entity.findDialect() == $SqlServer$: $DATEADD(s,-1,DATEADD(mm, DATEDIFF(m,0,GETDATE()), 0))$,$trunc(sysdate, 'mm')-1/24/60/60$} 
		    then h1.f_tablebase-d.f_using_base
		    when d.id is not null then d.f_last_tablebase
			when h1.f_tablebase is not null and d.id is null then h1.f_tablebase
		    else  d.f_initial_base end f_last_tablebase,		--上期指数
		d.f_tablebase,		  --本期底数
		d.f_return_fee,       --返还金额
		d.f_user_id,		  --气表编号
		d.f_userinfo_id,	  --分公司
		d.f_meter_type,		--气表类型
		d.f_hand_date,			--下发日期
		d.f_filiale,			--分公司
		d.f_outlets,			--营业网点
		case when d.inputtor is null then d.f_inputtor else d.inputtor end as f_inputtor,		--抄表员		
		d.f_user_type,			--用户类型（自动下账时，产生收费记录时使用）
		d.f_gasproperties,      --用气性质（自动下账时，产生收费记录时使用）
		d.f_meter_brand,        --气表品牌（自动下账时，产生收费记录时使用）
		d.f_meter_style,        --气表型号（自动下账时，产生收费记录时使用）
		d.f_meternumber,         --表号（自动下账时，产生收费记录时使用）
		d.id,						--抄表id				
		{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(d.f_meter_state,'未下发') f_meter_state,	
		 case when h1.f_hand_date =d.f_hand_date  then 1 else
                        0 end as states,  --抄表单状态
        case when d.f_hand_date <= d.f_operate_date then f_meterstate	
        else '正常' end f_oper_state			-- 是否是换表
from (
  select 
        version,				
        u.userinfo_version,
        u.f_balance,
        u.f_meter_type,     	
        u.f_meter_classify,			
        u.f_user_name,			
        u.f_address,				
        u.f_area,
        u.f_residential_area,
        u.f_meter_base,					
        u.f_user_id,
        u.f_price_type,			
		u.f_price_name,			
        u.f_userinfo_id,		
        u.f_price_id,			
        u.f_inputtor,				
        u.f_user_type,			
        u.f_gasproperties,      
        u.f_meter_brand,        
        u.f_meter_style,        
        u.f_meternumber,        
        u.f_initial_base,		
        u.f_filiale,			
        u.f_outlets,
        h.f_user_id h_user_id,		
        f_last_tablebase,
        h.f_tablebase,
        f_return_fee,
        h.id id,	
        f_hand_date,
        h.f_meter_state,			
        h.f_inputtor inputtor,
        u.f_meterState,
        u.f_operate_date,
        u.f_gas_date,
        c.f_operate_date changemeterdate,
        c.f_using_base
   from 
   (
       select t.*,s.f_price_type,s.f_price_name,
	    case when v.f_operat_type= '换表' then '换表'
	 	else '正常' end f_meterState, v.f_operate_date
       from 
          (select * from { entity.findDialect() == $SqlServer$: $V_user_table$,${sql.call($VUserTable$,{})}$} where f_table_state = '正常' and f_user_state = '正常' and f_meter_classify like '%卡表')  t 
          left join 
          { entity.findDialect() == $SqlServer$: $V_stairprice$,${sql.call($VStairPrice$,{})}$} s on t.f_price_id=s.f_price_id 
          left join
		  (select * from { entity.findDialect() == $SqlServer$: $V_record$,${sql.call($VRecord$,{})}$} ) v on v.f_user_id=t.f_user_id and v.f_state = '有效'
  ) u
  left join
  (
   select * from t_cardhand
   where f_hand_date>='{startDate} 00:00:00'
   and f_hand_date<='{endDate} 23:59:59'
      and f_meter_state != '冲正' and id not in (
      	select f_correct_id from t_correcthandplan where f_correct_state = '有效')
   ) h on h.f_user_id=u.f_user_id 
  left join
  (
   select c1.* from
   (select f_user_id,MAX(f_operate_date) f_operate_date from t_changemeter 
   group by f_user_id
   ) c
   left join
   t_changemeter c1 on c.f_user_id=c1.f_user_id and c.f_operate_date=c1.f_operate_date
   where c1.f_user_id is not null
  ) c on c.f_user_id=u.f_user_id
) d
left join
    (  
    select MAX(f_hand_date) f_hand_date,max(f_tablebase) f_tablebase,f_user_id from t_cardhand where
          f_meter_state != '冲正' and id not in (
      	select f_correct_id from t_correcthandplan where f_correct_state = '有效')
    group by f_user_id
     ) h1 on h1.f_user_id=d.f_user_id 
) u
where {condition}
order by f_user_id
