// 计算总购气（包含收费表和抄表记录）
SELECT 
	'总购气' AS record_type,
	SUM(times) times,
	SUM(fees) fees,
 	SUM(gas) gas 
FROM (
	SELECT 
		0 AS record_type,
		COUNT(id) times,
		SUM(f_preamount) + SUM(f_delaypay) AS fees,
		SUM(f_pregas) gas 
	FROM t_sellinggas 
	WHERE f_userinfo_id = {f_userinfo_id} and f_state != '冲正' and f_state != '无效'
	
	union ALL
	
	SELECT 
		0 AS record_type,
		COUNT(id) AS times,
		SUM(f_oughtfee) fees,
		SUM(f_oughtamount) AS gas 
	FROM ({${sql.call($VHandPlan$,{})} $}) t_
	WHERE f_whether_pay = '否' and f_meter_state != '冲正' and f_userinfo_id = {f_userinfo_id}
) t

UNION ALL 
// 补卡表
SELECT 
	'补卡金额' AS record_type,
	COUNT(id) times,
	SUM(f_cardfees) fees,
	0 AS gas 
FROM t_fillcard
WHERE f_userinfo_id = {f_userinfo_id}

UNION ALL 
// 换表
SELECT 
	'换表费' as record_type,
	COUNT(id) times,
	SUM(f_changemeter_fee) fess,
	0 AS gas  
FROM t_changemeter
WHERE f_userinfo_id = {f_userinfo_id}

UNION ALL 
// 过户表
SELECT 
	'过户费' AS record_type,
	COUNT(id) times,
	SUM(f_transfer_fees) fees,
	0 AS gas  
FROM t_transfer 
WHERE f_userinfo_id = {f_userinfo_id}

UNION ALL 
// 其他收费表
SELECT 
	'其他收费' AS record_type,
	COUNT(id) times, 
	SUM(f_collection) fees,
	0 AS gas 
FROM t_othercharge 
WHERE f_userinfo_id = {f_userinfo_id}

UNION ALL 
// 抄表记录中欠费记录
SELECT 
	'欠费金额' AS record_type,
	0 AS times,
	SUM(f_oughtfee) fees,
	0 AS gas 
FROM t_handplan 
WHERE f_whether_pay = '否' and f_meter_state != '冲正' and f_userinfo_id = {f_userinfo_id}

UNION ALL 
// 账户余额
SELECT 
	'账户余额' AS record_type,
	0 AS times,
	f_balance fees,
	0 AS gas 
FROM t_userinfo
WHERE f_userinfo_id = {f_userinfo_id}

UNION ALL 
// 收费表中，收费次数，总收款
SELECT 
	'售气收费' AS record_type,
	COUNT(id) AS times,
	SUM(f_collection) fees,
	0 AS gas 
FROM t_sellinggas
WHERE f_userinfo_id = {f_userinfo_id} and f_state = '有效'





