select * from (
                         select
                             u.f_table_state,
                             u.f_gasproperties,
                             u.f_filialeid f_orgid,
                             u.f_aroundmeter,
                             u.f_userfiles_id,
                             u.f_concentrator_id,
                             address.f_address,
                             tui.f_userinfo_code,
                             tui.f_user_name,
                             u.f_meter_classify,
                             gb.f_meter_brand,
                             gm.f_meter_style+gm.f_type f_meter_style,
                             sp.f_user_type,
                             sp.f_price_name,
                             sp.f_price_type,
                             u.f_meternumber,
                             case when tcon.f_main_userfilesid=u.f_userfiles_id then 1 else 0 end estateaccount
                         from
                             t_userfiles u with(nolock)
                      left join t_userinfo tui  on tui.f_userinfo_id = u.f_userinfo_id
                             left join t_user_address address with(nolock)
                         on u.f_useraddress_id = address.id
                             left join t_gasmodel gm with(nolock)
                         on u.f_gasmodel_id = gm.id
                             left join t_gasbrand gb with(nolock)
                         on u.f_gasbrand_id = gb.id
                             left join t_stairprice sp with(nolock)
                         on u.f_price_id = sp.f_price_id and u.f_filialeid = sp.f_filialeid and sp.f_state = '有效' and getdate()>=f_perform_date and getdate()<= sp.f_end_date
                            left join t_concentrator tcon with(nolock)
                         on tcon.id = u.f_concentrator_id
                     ) t
where {condition} and f_concentrator_id is not null
order by f_userinfo_code desc
