select * from (
  SELECT ui.f_userinfo_id,
         ui.f_userinfo_code,
         ui.f_user_name,
         ui.f_user_state,
         uf.f_meternumber,
         uf.f_user_type,
         uf.f_gasproperties,
         uf.f_meter_classify,
         uf.f_meter_base,
         uf.f_table_state,
         uf.f_balance_amount,
         (case
              when uf.f_balance_amount >= 0 then '正常'
              else '欠费'
             end
             ) f_money_state,
         gb.f_meter_brand,
         ad.f_address,
         uf.f_filialeid
  FROM t_userfiles uf with(nolock)
           LEFT JOIN t_userinfo ui with(nolock) ON uf.f_userinfo_id = ui.f_userinfo_id
           LEFT JOIN t_gasbrand gb with(nolock) ON uf.f_gasbrand_id = gb.id
           LEFT JOIN t_gasmodel gm with(nolock) ON uf.f_gasmodel_id = gm.id
           LEFT JOIN t_user_address ad with(nolock) ON uf.f_useraddress_id = ad.id
) t
WHERE
 {condition }
 and f_meter_classify = '物联网表' and f_table_state !='换表'
ORDER by f_userinfo_code desc
