SELECT
    t1.*, f_address
FROM
    (
        SELECT
            u1.f_gas_date,
            u1.f_userinfo_id,				                            --用户id
            u1.f_userfiles_id,										--气表id
            u2.f_userinfo_code,				                        --用户编号
            u2.f_user_name,
            u2.f_has_heater ,                                         --是否热水器
            u2.f_has_stove,                                            --是否壁挂炉
            u1.f_useraddress_id,				                        --用户名				                        --用户地址
            u1.f_user_type,                                           --用户类型
            u1.f_gasproperties,                                       --用气性质
            u1.f_meternumber,				                            --表号
            u1.f_meter_base,                                          --气表底数
            u1.f_total_fee,                                           --累够金额
            u1.f_balance_amount,                                      --表上余额
            u1.f_startuse_date,					                    --启用日期
            u4.f_meter_brand,                                         --气表品牌
            u1.f_table_state,                                         --气表品牌
            u1.f_filialeid,											--组织id（查询用）
            isnull(tog.togname,u1.f_orgname) f_orgname,											    --组织名称	(显示用，本应根据f_filialeid关联，组织名称，
            --现在先显示操作公司（f_orgname）)
            u6.f_signal,                                              --信号强度
            u6.f_batteryLevel,	                                    --电压
            u6.f_snr,                                                 --噪音比
            u6.f_magneticInterference,                                --磁干扰
            case
                when u6.f_valveState = 1 then '关阀'
                when u6.f_valveState = 0 then '开阀'
                when u6.f_valveState = 2 then '异常'
                when u6.f_valveState = 3 then '无阀门状态'
                when u6.f_valveState = 4 then '普关'
                else '未上报' end f_valvestate	                          --阀门状态
            --需要表上的其他最新信息，依次往下写即可
        FROM
            t_userfiles u1 with(nolock)
                left join t_userinfo u2 with(nolock) ON u1.f_userinfo_id= u2.f_userinfo_id
                left join (select id togid,name togname from t_organization with(nolock) ) tog on tog.togid = u1.f_filialeid
                left join t_gasbrand u4 with(nolock) ON u1.f_gasbrand_id= u4.id
                left join t_meteread u6 with(nolock) on u1.f_meteread_maxid=u6.id
        WHERE u1.f_meter_classify='物联网表'
    ) t1
        left join   t_user_address  t2  on t1.f_useraddress_id=t2.id
where {condition}
ORDER BY
    f_userinfo_code DESC
