SELECT
    *
FROM
    (
        SELECT
            ui.f_userinfo_id,
             null f_ischeck,--用户编号
            ui.f_userinfo_code,				                            --用户编号
            uf.f_user_id,						                            --表编号
            uf.f_userfiles_id,
            uf.f_param_list,
            uf.f_meternumber,				                            --表号
            ui.f_user_name,					                            --用户名
            a.f_address,						                            --用户地址
            uf.f_user_type,                                     --用户类型
            uf.f_gasproperties,                                 --用气性质
            gb.id AS f_gasbrand_id,	                            --品牌识别列
            gb.f_meter_brand,				                            --气表品牌
            gm.id AS f_gasmodel_id,	                            --型号识别列
            gm.f_meter_style,				                    --气表型号
            gb.f_meter_type,				                            --气表类型
            case when uf.f_table_state='正常' then '在用' else uf.f_table_state end  f_table_state,		--气表状态
            gb.f_alias,                                         --表厂别名
            ui.f_orgid,
            uf.f_gas_date,
            uf.f_orgname,
            uf.f_depid,
            uf.f_operatorid
        FROM
            t_userfiles uf with(nolock)
	LEFT JOIN t_user_address a with(nolock) on uf.f_useraddress_id=a.id
            LEFT JOIN t_userinfo ui with(nolock) ON (ui.f_userinfo_id= uf.f_userinfo_id)
            LEFT JOIN t_gasbrand gb with(nolock) ON (uf.f_gasbrand_id= gb.id)
            LEFT JOIN t_gasmodel gm with(nolock) ON (uf.f_gasmodel_id= gm.id)
        WHERE uf.f_table_state !='换表' and ui.f_user_state='正常'
    ) t_userfiles
WHERE {condition}
ORDER BY
    f_userfiles_id DESC

