/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import util.SSLClient;

public class HttpPlugin {
    private static Logger log = Logger.getLogger(HttpPlugin.class);

    public JSONObject post(String url, JSONObject data) {
        log.debug((Object)("url :" + url));
        log.debug((Object)("data :" + data));
        try {
            HttpPost hp = new HttpPost(url);
            hp.setHeader("Content-Type", "application/JSON");
            hp.setEntity((HttpEntity)new StringEntity(data.toString(), "UTF-8"));
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpResponse response = httpClient.execute((HttpUriRequest)hp);
            int code = response.getStatusLine().getStatusCode();
            log.debug((Object)("\u72b6\u6001\u7801" + code));
            if (code == 200) {
                log.debug((Object)("\u8fd4\u56de\u6570\u636e" + response.getEntity()));
                String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                log.debug((Object)("\u8fd4\u56de\u5185\u5bb9" + result));
                return new JSONObject(result);
            }
            throw new RuntimeException("status = " + code);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject postByRequestBody(String url, String data) {
        log.debug((Object)("url :" + url));
        log.debug((Object)("data :" + data));
        try {
            String line;
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("data", data));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((chain, authType) -> true).build();
            CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
            CloseableHttpResponse httpresponse = httpClient.execute((HttpUriRequest)httpPost);
            int response = httpresponse.getStatusLine().getStatusCode();
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpresponse.getEntity().getContent()));
            StringBuilder responseContent = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                responseContent.append(line);
            }
            String result = responseContent.toString();
            log.debug((Object)("\u72b6\u6001\u7801" + response));
            if (response == 200) {
                log.debug((Object)("\u8fd4\u56de\u5185\u5bb9" + result));
                return new JSONObject(result);
            }
            throw new RuntimeException("status = " + response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject doPost(String url, JSONObject data) {
        log.debug((Object)("url :" + url));
        log.debug((Object)("data :" + data));
        JSONObject ret = new JSONObject();
        try {
            HttpPost hp = new HttpPost(url);
            hp.setHeader("Content-Type", "application/JSON");
            hp.setEntity((HttpEntity)new StringEntity(data.toString(), "UTF-8"));
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpResponse response = httpClient.execute((HttpUriRequest)hp);
            int code = response.getStatusLine().getStatusCode();
            log.debug((Object)("\u72b6\u6001\u7801" + code));
            if (code == 200) {
                log.debug((Object)("\u8fd4\u56de\u6570\u636e" + response.getEntity()));
                String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                log.debug((Object)("\u8fd4\u56de\u5185\u5bb9" + result));
                if (result.startsWith("{")) {
                    return new JSONObject(result);
                }
            } else {
                ret.put("code", code);
            }
        }
        catch (Exception e) {
            ret.put("code", 501);
            ret.put("msg", (Object)e.getMessage());
        }
        return ret;
    }

    public JSONArray sqlpost(String url, JSONObject data) {
        log.debug((Object)("url :" + url));
        log.debug((Object)("data :" + data));
        JSONArray array = new JSONArray();
        try {
            JSONObject ret = new JSONObject();
            HttpPost hp = new HttpPost(url);
            hp.setHeader("Content-Type", "application/JSON");
            hp.setEntity((HttpEntity)new StringEntity(data.toString(), "UTF-8"));
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpResponse response = httpClient.execute((HttpUriRequest)hp);
            int code = response.getStatusLine().getStatusCode();
            log.debug((Object)("\u72b6\u6001\u7801" + code));
            if (code == 200) {
                log.debug((Object)("\u8fd4\u56de\u6570\u636e" + response.getEntity()));
                String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                log.debug((Object)("\u8fd4\u56de\u5185\u5bb9" + result));
                if (result.startsWith("[")) {
                    return new JSONArray(result);
                }
                if (result.startsWith("{")) {
                    array.put((Object)new JSONObject(result));
                }
                return array;
            }
            throw new RuntimeException("status = " + code);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JSONObject get(String path) {
        JSONObject accob = null;
        log.debug((Object)("url===>" + path));
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpGet getReqacc = new HttpGet(path);
            CloseableHttpResponse httpResacc = httpclient.execute((HttpUriRequest)getReqacc);
            int code = httpResacc.getStatusLine().getStatusCode();
            if (code == 200) {
                HttpEntity accent = httpResacc.getEntity();
                if (accent != null) {
                    String accentstr = EntityUtils.toString((HttpEntity)accent, (String)"utf-8");
                    accob = new JSONObject(accentstr);
                    return accob;
                }
                return new JSONObject();
            }
            return new JSONObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String post(String url, String data) {
        try {
            SSLClient httpclient = new SSLClient();
            HttpPost postRequest = new HttpPost(url);
            postRequest.setEntity((HttpEntity)new StringEntity(data, "UTF-8"));
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)postRequest);
            int StatusCode = httpResponse.getStatusLine().getStatusCode();
            if (StatusCode != 200) {
                throw new RuntimeException("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801:" + StatusCode);
            }
            HttpEntity entity = httpResponse.getEntity();
            String rs = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return rs;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getUrl(String url, JSONObject jsonObject) {
        StringBuilder sb = new StringBuilder(url);
        sb.append("?");
        int i = 0;
        try {
            for (String key : jsonObject.keySet()) {
                if (jsonObject.get(key) != null && !"".equals(jsonObject.get(key))) {
                    sb.append(key).append("=").append(URLEncoder.encode(jsonObject.get(key).toString(), "UTF8"));
                }
                if (++i >= jsonObject.length()) continue;
                sb.append("&");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sb.toString().replaceAll("\\+", "%20").replaceAll("%3A", ":");
    }

    public static Map<String, String> parseRequestParamMap(Map<String, String[]> map) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Iterator<Map.Entry<String, String[]>> entries = map.entrySet().iterator();
        String name = "";
        String value = null;
        while (entries.hasNext()) {
            Map.Entry<String, String[]> entry = entries.next();
            name = entry.getKey();
            if (name == null || "".equals(name.trim())) continue;
            String[] objvalue = entry.getValue();
            if (objvalue == null) {
                value = null;
            } else if (objvalue instanceof String[]) {
                String[] values = objvalue;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = objvalue.toString();
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }
}

