select 
	* 
from (
	select 
		u.f_user_id,
		u.f_userinfo_id,
		u.f_user_state,
		u.f_user_name,
		u.f_address,
		u.f_user_phone,
		u.f_area,
		isnull(u.f_balance, 0) f_balance,						 							 --账户余额

		isnull(h.f_oughtfee, 0) f_oughtfee,						  							 --欠费金额

		isnull(h.overdue, 0) overdue,							  							 --滞纳金

		case when u.f_balance-(isNull(h.f_oughtfee,0)+isNull(h.overdue,0))<=0 then 0 
			else u.f_balance-(isnull(h.f_oughtfee,0)+isNull(h.overdue,0)) end  actuallybalance, --实际账户余额

		isnull(u.f_predeposit, 0) f_predeposit,						   						 --最低预存款

		case when isnull(u.f_predeposit,0) = 0
			then -1 
		when u.f_balance-(isNull(h.f_oughtfee,0)+isnull(h.overdue,0))-isnull(u.f_predeposit,0) > 0 then 1 else 0
			end f_predeposit_state 													 --状态1 预存款够  状态0 预存款不足

	from 
		V_user_table u 
		left join
		(
			select 
				f_userinfo_id,          		--用户编号

				f_balance,          	 		--用户账户结余

				sum(f_oughtfee) f_oughtfee, 		     	 		--欠费金额

				sum(isnull(overdue,0)) overdue					 		--滞纳金

			from 
			  (
			   select 
					 handplan_id,											--抄表记录id

					 convert(decimal(18,2),f_oughtamount) f_oughtamount,	--应交气量

					 convert(decimal(18,2),f_oughtfee) f_oughtfee,			--应交金额

					 overduedays,											--滞纳天数

					 u.f_userinfo_id,          		--用户编号

					 u.f_balance,          	 		--用户账户结余

					 case 
					 when overduedays<=0 then 0 
					 when  last_tablebase =f_last_tablebase then 
					(case when overduedays*zhinajinbilv*(f_oughtfee-u.f_balance)>=f_oughtfee 
					then convert(decimal(18,2),f_oughtfee) 
					else convert(decimal(18,2),overduedays*zhinajinbilv*(f_oughtfee-u.f_balance)) end) 
					else
					(case when overduedays*zhinajinbilv*f_oughtfee>=f_oughtfee 
					then convert(decimal(18,2),f_oughtfee) 
					else convert(decimal(18,2),overduedays*zhinajinbilv*f_oughtfee) end) 
					end as overdue  
			   from( 
					  select 
					  h.id as handplan_id,
					  h1.last_tablebase,		
					  f_last_tablebase,		
					  f_tablebase,
					  f_input_date,
					  f_hand_date,			
					  f_oughtamount,			
					  f_oughtfee,			
					  h.f_user_id,	
					  f_userinfo_id,		
					  DATEDIFF(dd,f_end_date,getdate()) overduedays, --滞纳天数

					  case when f_user_type='民用' then (select cast(value as float) from  t_singlevalue where name='民用违约金') else 
					  (select cast(value as float) from  t_singlevalue where name='非民用违约金') end zhinajinbilv							   --滞纳金比率

					  from 
						 (
						 select * from t_handplan
						 where f_whether_pay='否' and f_meter_state = '已抄表'
						 ) h
						 left join
						 (
						  select MIN(f_last_tablebase) last_tablebase,f_user_id from t_handplan
						  group by f_user_id
						 ) h1 on h.f_user_id=h1.f_user_id
					 ) h 
				   left join 
				   t_userinfo u on h.f_userinfo_id=u.f_userinfo_id
				 ) u
			group by  f_userinfo_id,f_balance
		) h
		on u.f_userinfo_id=h.f_userinfo_id
		where u.f_user_table != '销户' and u.f_user_table != '停用'
) p
where {condition}
order by {orderitem}