package meter;

import cn.hutool.core.util.XmlUtil;
import cn.hutool.http.webservice.SoapClient;
import com.af.plugins.DateTools;
import com.af.plugins.RestTools;
import com.aote.entity.EntityServer;
import com.aote.rs.ProductService;
import com.aote.rs.utils.FileConfig;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

/**
 * 批量sql的操作
 */
public class SettleTools {
    static Logger log = Logger.getLogger(EntityServer.class);

    @Autowired
    private RestTools restTools;
    /**
     * 获取批量sql的values
     */
    public static String getAllValue(JSONArray json){
        log.info("将要进行"+json.length()+"批量sql values获取");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();
                Object value = (Object)map.get(key);
                sbs.append("'");
                sbs.append(value);
                sbs.append("'");
                if(iterator.hasNext()){
                    sbs.append(",");
                }
            }
            if(i == json.length()-1){
                sbs.append(")");
            }else{
                sbs.append("),");
            }
        }
        return sbs.toString();
    }

    /**
     * 获取批量sql的fileds
     * @param json
     * @return
     */
    public static String getAllFields(JSONArray json){
        log.info("将要进行"+json.length()+"批量sql fields");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            String nowLineValue = "";
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();
                sbs.append(key);
                if(iterator.hasNext()){
                    sbs.append(",");
                }
            }
            sbs.append(")");
            break;
        }
        return sbs.toString();
    }

    public static String getHandplanValues(JSONArray json){


        return "";
    }

    public static String getSellinggasValues(JSONArray json){

        return "";
    }


    /**
     * 判断字符串或者数字是否相等
     * @param num1
     * @param num2
     * @return
     */
    public static boolean judgeValue(Object num1,Object num2){
        if(num1==null || num2==null){
            return false;
        }
        float judgenum1 = 0;
        float judgenum2 = 0;
        if(num1 instanceof Integer && num2 instanceof  Integer){
            if(num1 == num2 ) return true; else return false;
        }
        try{
            if(num1 instanceof Integer){
                judgenum1 = Float.parseFloat(Integer.toString((Integer) num1));
            }else{
                judgenum1 = Float.parseFloat((String)num1);
            }
        }catch(Exception e){
            return false;
        }
        try{
            judgenum2 = Float.parseFloat(num2.toString());
        }catch(Exception e){
            return false;
        }
        if(num1 instanceof String && num2 instanceof  String){
            if(num1.equals(num2)) return true; else return false;
        }
        if(judgenum1-judgenum2 ==0){
            return true;
        }
        return false;
    }

    /**
     * 获取指令中是否包含某个sellinggas id
     */
    public String getInstructValue(String instructcontent,String sellid){
        if(instructcontent == null || "".equals(instructcontent)){
            return "";
        }
        if(sellid == null || "".equals(sellid)){
            return "";
        }
        //生成返回值
        try{
            JSONObject json = new JSONObject(instructcontent);
            Object dataId =  json.get("dataId");
            String value = String.valueOf(dataId);
            if(value.equals(sellid)){
                return sellid;
            }
        }catch(Exception e){
            return "";
        }
        return "";
    }

    public boolean iszeor(Object o1,Object o2){
        if(o1 instanceof BigDecimal){
            o1 = (BigDecimal)o1;
            o1 = ((BigDecimal) o1).doubleValue();
        }
        if(o2 instanceof Integer){
            o2 = (Integer)o2;
            o2 = ((Integer) o2).doubleValue();
        }
        if((Double)o1-(Double)o2 == 0){
            return true;
        }else{
            return false;
        }

    }

    /**
     * 微信支付发送请求
     */
    public JSONObject weixinpay(JSONObject json,String url){
        //验证数据
        if(url == null || "".equals(url) || json == null){
            return new JSONObject();
        }
        //组织url

        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("http://");
        stringBuffer.append(url);
        String post = restTools.post(url, json);
        JSONObject resultobj = new JSONObject(post);
        return resultobj;
    }

//    public JSONObject ncpush(JSONObject json,String url){
//        //验证数据
//        if(url == null || "".equals(url) || json == null){
//            return new JSONObject();
//        }
//        //组织url
//
//        StringBuffer stringBuffer = new StringBuffer();
//        stringBuffer.append("http://");
//        stringBuffer.append(url);
//
//        String post = null;
//        try {
//            post = restTools.post(url, json);
//        } catch (Exception e) {
//            JSONObject errorre = new JSONObject();
//            errorre.put("msg","推送失败");
//            return errorre;
//        }
//        JSONObject resultobj = new JSONObject(post);
//        return resultobj;
//    }

    /**
     * 获取批量sql的values
     */
    public static String getAllsomeValue(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql values获取");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();
                Object value = (Object)map.get(key);
                sbs.append("'");
                sbs.append(value);
                sbs.append("'");
                if(iterator.hasNext()){
                    sbs.append(",");
                }
            }
            if(i == json.length()-1){
                sbs.append(")");
            }else{
                sbs.append("),");
            }
        }
        return sbs.toString();
    }

    /**
     * 获取批量sql的fileds
     * @param json
     * @return
     */
    public static String getAllsomFields(JSONArray json){
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            String nowLineValue = "";
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();

                sbs.append(key);
                if (iterator.hasNext()) {
                    sbs.append(",");
                }

            }
            sbs.append(")");
            break;
        }
        return sbs.toString();

    }

    /**
     * 解决 json中有 '  无法存入数据库问题(替换 )
     * @param json
     * @return
     */
    public String replacejson (JSONObject json){
        return json.toString().replaceAll("'","~");
    }

    /**
     * 解决 json中有 '  无法存入数据库问题(解析 )
     * @param str
     * @return
     */
    public JSONObject jsonreplace (String str){
        String s = str.replaceAll("~", "'");
        System.out.println(s);
        JSONObject jsonObject = new JSONObject(s);
        return jsonObject;
    }

    /**
     * 调用 webservice的ncpush
     * @param url
     * @param method
     * @param namespace
     * @param param
     * @return
     */
    public static JSONObject ncpush(String url,String method,String namespace,JSONObject param) {
        //开始推送数据
        //String point = "http://192.168.10.184:8086/uapws/service/nc.itf.arap.gather.IGatherService?wsdl";
        //String method = "igat:CreateGatherBill";
        //String namespace = "http://gather.arap.itf.nc/IGatherService";
        JSONObject returnjson = new JSONObject();
        log.debug("推送==>"+param.toString());
        // 新建客户端
        SoapClient client = SoapClient.create(url)
                // 设置要请求的方法，此接口方法前缀为web，传入对应的命名空间
                .setMethod(method, namespace)
                // 设置参数，此处自动添加方法的前缀：web
                .setParam("string", param.toString(),false);
        String send = client.send(true);
        log.debug("返回数据"+send);
        //返回数据为xml格式,解析结果
        Document document = XmlUtil.readXML(send);
        NodeList aReturn = document.getElementsByTagName("return");
        Node item = aReturn.item(0);
        String textContent = item.getTextContent();
        try{
            JSONObject resultobj = new JSONObject(textContent);
            String resultvalue = (String) resultobj.get("result");
            String msg = (String) resultobj.get("msginfo");
            returnjson.put("state",resultvalue);
            returnjson.put("msg",msg);
            return returnjson;
        }catch(Exception e){
            log.debug("返回出错");
            return new JSONObject();
        }
    }
    public static void push3() {
        //开始推送数据 http://gather.arap.itf.nc/IGatherService
        //http://192.168.10.184:8086/uapws/service/nc.itf.arap.gather.IGatherService
        String point = "http://192.168.10.184:8086/uapws/service/nc.itf.arap.gather.IGatherService?wsdl";
        String method = "igat:CreateGatherBill";
        String namespace = "http://gather.arap.itf.nc/IGatherService";
        JSONObject json = new JSONObject();
        json.put("data","test");
        String senddata = json.toString();
        senddata = senddata.replace("","'");
        // 新建客户端
        SoapClient client = SoapClient.create(point)
                // 设置要请求的方法，此接口方法前缀为web，传入对应的命名空间
                .setMethod(method, namespace)
                // 设置参数，此处自动添加方法的前缀：web
                .setParam("string", json.toString(),false);

        String send = client.send(true);
        log.debug("返回数据"+send);
        System.out.println(send);

    }

    public JSONObject push4(JSONObject param) throws Exception {
        JSONObject returnjson = new JSONObject();
        if(param == null) return returnjson;
        //String url = "http://192.168.10.6/uapws/service/nc.itf.arap.gather.IGatherService";
        String url = "";
        JSONObject urldata = new JSONObject();
        try{
            urldata = FileConfig.getjsonfromfile("ncpushurl.json");
            log.debug("获取到得json"+urldata.toString());
        }catch(Exception e){
            throw new Exception("获取ncpushurl.json失败");
        }
        if(urldata.has("url")){
            url = urldata.getString("url");
        }else{
            throw new Exception("获取ncpushurl.json配置文件中url失败");
        }
        String postbody = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:igat=\"http://gather.arap.itf.nc/IGatherService\">\n" +
                "   <soapenv:Header/>\n" +
                "   <soapenv:Body>\n" +
                "      <igat:CreateGatherBill>\n" +
                "         <!--Optional:-->\n" +
                "         <string>"+param.toString()+"</string>\n" +
                "      </igat:CreateGatherBill>\n" +
                "   </soapenv:Body>\n" +
                "</soapenv:Envelope>";
        JSONObject headerobj = new JSONObject();
        headerobj.put("Content-Type","text/xml;charset=UTF-8");
        headerobj.put("SOAPAction","urn:CreateGatherBill");
        String post = restTools.post(url, postbody,headerobj.toString());
        log.debug("返回数据"+post);
        System.out.println(post);
        //返回数据为xml格式,解析结果
        Document document = XmlUtil.readXML(post);
        NodeList aReturn = document.getElementsByTagName("return");
        Node item = aReturn.item(0);
        String textContent = item.getTextContent();
        try{
            JSONObject resultobj = new JSONObject(textContent);
            String resultvalue = (String) resultobj.get("result");
            String msg = (String) resultobj.get("msginfo");
            returnjson.put("state",resultvalue);
            returnjson.put("msg",msg);
            return returnjson;
        }catch(Exception e){
            log.debug("返回出错");
            return new JSONObject();
        }
    }

    /**
     * 获取某个时间段内,这个时间重合的部分
     */
    public JSONArray  getntervaltime(JSONArray times,JSONObject intervaltime){
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        JSONArray jsonArr = new JSONArray();

        for(int i=0; i<times.length();i++){
            JSONObject jsonitem = new JSONObject();
            JSONObject timeitem = (JSONObject)times.get(i);
            int flag = (int)timeitem.get("flag");
            Date pushstartdate = null;
            Date pushenddate = null;
            try{
                pushstartdate = simpleDateFormat.parse((String) timeitem.get("f_push_start_date"));
                pushenddate = simpleDateFormat.parse((String) timeitem.get("f_push_end_date"));
            }catch(Exception e){

            }
            //开始在已经推送区间内
            try{
                if(flag == 0){
                    Date enddate = simpleDateFormat.parse((String) intervaltime.get("endDate"));
                    jsonitem.put("startdate",(String) intervaltime.get("startDate"));
                    if( enddate.getTime()>=pushstartdate.getTime() && enddate.getTime()< pushenddate.getTime()){
                        jsonitem.put("enddate",simpleDateFormat.format(pushenddate));
                    }else{
                        jsonitem.put("enddate",(String) intervaltime.get("endDate"));
                    }
                }
                if(flag == 1){
                    Date enddate = simpleDateFormat.parse((String) intervaltime.get("startDate"));
                    jsonitem.put("enddate",(String) intervaltime.get("endDate"));
                    if( enddate.getTime()> pushstartdate.getTime() && enddate.getTime()<= pushenddate.getTime()){
                        jsonitem.put("startdate",(String) intervaltime.get("startDate"));
                    }else{
                        jsonitem.put("startdate",simpleDateFormat.format(pushstartdate));
                    }
                }
                jsonArr.put(jsonitem);
            }catch(Exception e){

            }
        }
        return jsonArr;
    }
    /**
     *
     */
    public JSONArray mergeUserPush(JSONArray pushdata){
        JSONArray resultarr = new JSONArray();
        if(pushdata.length()>0){
            JSONObject repeatObject = new JSONObject();
            for(int i=0; i<pushdata.length(); i++){
                repeatObject =  pushdata.getJSONObject(i);
                for(int j=0;j< pushdata.length();j++){
                    JSONObject items = pushdata.getJSONObject(i);
                    if(repeatObject.getString("customer").equals(items.getString("customer"))){
                        BigDecimal money = items.getBigDecimal("money");
                        int num = items.getInt("num");
                        repeatObject.put("money",repeatObject.getBigDecimal("money").add(money));
                        repeatObject.put("num",repeatObject.getInt("num")+num);
                    }
                }
                resultarr.put(repeatObject);
            }
        }
        return resultarr;
    }
    public JSONArray mergeUserPush2(JSONArray pushdata){
        JSONArray resultarr = new JSONArray();
        if(pushdata.length()>0){
            JSONObject repeatObject = new JSONObject();
            for(int i=0; i<pushdata.length(); i++){
                repeatObject =  pushdata.getJSONObject(i);
                for(int j=0;j< pushdata.length();j++){
                    JSONObject items = pushdata.getJSONObject(i);
                    if(repeatObject.getString("f_customer").equals(items.getString("f_customer"))){
                        BigDecimal money = items.getBigDecimal("f_preamount");
                        BigDecimal collection = items.getBigDecimal("f_collection");
                        BigDecimal pregas = items.getBigDecimal("f_pregas");
                        repeatObject.put("f_preamount",repeatObject.getBigDecimal("f_preamount").add(money));
                        repeatObject.put("f_collection",repeatObject.getBigDecimal("f_collection").add(collection));
                        repeatObject.put("f_pregas",repeatObject.getBigDecimal("f_pregas").add(pregas));
                    }
                }
                resultarr.put(repeatObject);
            }
        }
        return resultarr;
    }

    /**
     * 比较时间(规定结束大于开始返回true)
     */
    public boolean repeatTime(String starttime,String endtime){
        if(starttime==null || endtime==null || "".equals(starttime) || "".equals(endtime)) return false;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start =null;
        Date end=null;
        try {
            start = df.parse(starttime);
            end = df.parse(endtime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if(start.getTime()< end.getTime()){
            return true;
        }
        else{
            return false;
        }
    }

    /**
     * 公共sql模板
     * @return
     */
    public ArrayList<String> getfiles(){
        ArrayList<String> strings = new ArrayList<>();
        strings.add("f_userinfo_code");
        strings.add("f_user_type");
        strings.add("f_customer");
        strings.add("f_user_name");
        strings.add("f_pregas");
        strings.add("f_preamount");
        strings.add("f_collection");
        strings.add("f_payment");
        strings.add("f_operate_date");
        strings.add("f_type");
        strings.add("f_state");
        strings.add("f_pay_accounts");
        strings.add("f_pay_account_code");
        return strings;
    }

    //将jsonarray转为sql
    public String jsontoSql(JSONArray arr){
        if(arr.length()==0) return "";
        StringBuffer header = new StringBuffer();
        StringBuffer body = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        ArrayList<String> getfiles = getfiles();
        ArrayList<Object> defaultvalue = new ArrayList<>();
        boolean headerflag = false;
        for(int i =0;i<arr.length();i++){
            JSONObject pushdata = (JSONObject) arr.get(i);
            Iterator<String> iterator = getfiles.iterator();
            body.append("(");
            while(iterator.hasNext()){
                String next = iterator.next();
                if(!headerflag){
                    header.append(next);
                    if(iterator.hasNext()){
                        header.append(",");
                    }
                }
                String otherString = "";
                if(pushdata.has(next)){
                    Object o= pushdata.get(next);
                    if(o instanceof String){
                        otherString = (String) o;
                    }else if(o instanceof BigDecimal){
                        BigDecimal bd = (BigDecimal) o;
                        otherString = bd.toString();
                    }else if(o instanceof Integer){
                        otherString = Integer.toString((Integer) o);
                    }else if(o instanceof Double){
                        otherString = Double.toString((Double) o);
                    }else if(o instanceof Float){
                        otherString = Float.toString((Float) o);
                    }
                }
                body.append("'");
                if(defaultvalue.contains(next) && "".equals(otherString)){
                    otherString = "0";
                }
                if(otherString=="" || otherString==null){
                    body.append("");
                }else{
                    body.append(otherString);
                }
                body.append("'");
                if(iterator.hasNext()){
                    body.append(",");
                }
            }
            headerflag=true;
            body.append(")");
            if(i < arr.length()-1){
                body.append(",");
            }
        }
        return "("+header.toString()+")"+ " values"+body.toString();
    }

    /**
     * 对于结果进行排序
     * @param sources
     * @param sortstr
     * @return
     */
    public JSONArray sortvalueAddinfo(JSONArray sources,String sortstr){
        JSONArray jsonarr = new JSONArray();
        if(sortstr == null || "".equals(sortstr)) return sources;
        String[] splitstr = sortstr.split(",");
        if(splitstr.length==0)  return sources;
        JSONObject souritems = null;
        String nowsortstr = null;
        for(int j =0;j<splitstr.length;j++){
            nowsortstr = new String(splitstr[j]);
            boolean flag = false;
            for(int i =0 ;i< sources.length();i++){
                souritems = (JSONObject) sources.get(i);
                if(nowsortstr.equals(souritems.getString("value_type"))){
                    flag = true;
                    jsonarr.put(souritems);
                    break;
                }
            }
        }
        return jsonarr;
    }


}


