package com.aote.rs.utils;

import cn.hutool.json.serialize.JSONSerializer;

import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.junit.Test;

import java.util.*;

public class aofeng {
    /**
     * 使用HttpClient4.5版本对指定接口路径发送POST请求
     *
     * @param httpUrl 指定接口路径
     * @param params  接口路径需要携带的参数集
     * @return 接口返回的消息
     */
    public static String doPost(String httpUrl, String params) {
        String result = null;
        //声明httpClient,httpResponse于try...catch语句外.方便最后关闭资源
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(httpUrl);
            //HttpEntity是一个接口,所有参数均是通过其子类携带
            //声明HttpEntity的实现子类UrlEncodedFormEntity用于携带参数
            //UrlEncodedFormEntity构造函数只接受BasicNameValuePair对象,符合程序逻辑
            StringEntity stringEntity = null;
            if (!params.isEmpty()) {
                stringEntity = new StringEntity(params,"UTF8");
                stringEntity.setContentEncoding("UTF8");
                stringEntity.setContentType("application/json");
            }
            //将绑定了参数的HttpEntity子类实现类存入HttpPost对象中
            httpPost.setEntity(stringEntity);
            //设置请求头
            httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
            //向指定接口发送POST请求
            httpResponse = httpClient.execute(httpPost);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                result = EntityUtils.toString(httpResponse.getEntity());
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            //逐一关闭使用过的资源
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void syncKSfromAF() {
        try {

            int a = 12;
            LinkedHashMap<String, Object> hashmap = new LinkedHashMap<String, Object>();


            JSONObject jsonObject = new JSONObject();
            jsonObject.put("f_last_date", "2018-09-18 16:10:23.000");
            jsonObject.put("f_size", a);
            jsonObject.put("f_last_userinfo_code", "50004787");

            String aofenshuju = aofeng.doPost("http://192.168.10.14:8300/rs/logic/getMasterUser", jsonObject.toString());
            System.out.println(aofenshuju);
            System.out.println("开始");




        } catch (Exception e) {
            e.printStackTrace();
        }
    }




}
