package com.aote.rs.utils;

import org.apache.commons.codec.digest.DigestUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.*;
import java.util.Map.Entry;

/**
 * 生产签名和验签
 */
public class SignUtils {

    /**
     * 方法描述:将字符串MD5加码 生成32位md5码
     *
     */
    public static String md5(String inStr) {
        try {
            return DigestUtils.md5Hex(inStr.getBytes("UTF-8"));
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5签名过程中出现错误");
        }
    }

    /**
     * 方法描述:签名字符串
     *
     * @author
     * @param params 需要签名的参数
     * @param appSecret 签名密钥
     * @return
     */
    public static String sign(HashMap<String, String> params, String appSecret) {
        if(appSecret == null || "".equals(appSecret)){
            throw new RuntimeException("密钥不能为空");
        }
        if(params == null || params.isEmpty()){
            throw new RuntimeException("参数列不能为空");
        }
        StringBuilder valueSb = new StringBuilder();
        if(params.get("appSecret") == null){
            params.put("appSecret", appSecret);
        }
        valueSb = SignUtils.getSignString(params);
        params.remove("appSecret");
        return md5(valueSb.toString());
    }

    /**
     * 拼接字符串
     * @param params
     * @return
     */
    public static StringBuilder getSignString(HashMap<String, String> params){
        StringBuilder resultTemplate = new StringBuilder();
        // 将参数以参数名的字典升序排序
        Map<String, String> sortParams = new TreeMap<String, String>(params);
        Set<Entry<String, String>> entrys = sortParams.entrySet();
        Iterator<Entry<String, String>> iterator = entrys.iterator();
        // 遍历排序的字典,并拼接value1+value2......格式
        while(iterator.hasNext()){
            Entry<String, String> next = iterator.next();
            resultTemplate.append(next.getKey());
            resultTemplate.append("=");
            resultTemplate.append(next.getValue());
            if(iterator.hasNext()){
                resultTemplate.append("&");
            }
        }
        return resultTemplate;
    }

    /**
     * 方法描述:验证签名
     *
     * @author
     * @param appSecret 加密秘钥
     * @param request
     * @return
     * @throws Exception
     */
    public static boolean verify(String appSecret, HttpServletRequest request) throws Exception {

        String sign = request.getParameter("sign");
        if (sign == null) {
            throw new Exception(URLEncoder.encode("请求中没有带签名", "UTF-8"));
        }
        HashMap<String, String> params = new HashMap<String, String>();

        // 获取url参数
        @SuppressWarnings("unchecked")
        Enumeration<String> enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paramName = enu.nextElement().trim();
            if (!paramName.equals("sign")) {
                // 拼接参数值字符串并进行utf-8解码，防止中文乱码产生
                params.put(paramName, URLDecoder.decode(request.getParameter(paramName), "UTF-8"));
            }
        }
        params.put("appSecret", appSecret);

        // 将参数以参数名的字典升序排序
        Map<String, String> sortParams = new TreeMap<String, String>(params);
        Set<Entry<String, String>> entrys = sortParams.entrySet();

        // 遍历排序的字典,并拼接value1+value2......格式
        StringBuilder values = new StringBuilder();
        for (Entry<String, String> entry : entrys) {
            values.append(entry.getValue());
        }
        String mysign = md5(values.toString());
        return mysign.equals(sign);
    }

    /**
     *
     * @param params
     * @param appSecret
     * @param sign
     * @return
     */
    public static boolean verifybd(HashMap<String, String> params, String appSecret,String sign) {
        if(appSecret == null || "".equals(appSecret)){
            throw new RuntimeException("密钥不能为空");
        }
        if(params == null || params.isEmpty()){
            throw new RuntimeException("参数列不能为空");
        }
        StringBuilder valueSb = new StringBuilder();
        if(params.get("appSecret") == null){
            params.put("appSecret", appSecret);
        }
        valueSb = SignUtils.getSignString(params);
        String mysign = md5(valueSb.toString());
        return mysign.equals(sign);
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<>();
        map.put("appid","{\"name\":\"123\"}");
        String sign = SignUtils.sign(map, "123456");
        System.out.println(sign);
    }
}