package com.aote.rs.third;

import com.af.plugins.RestTools;
import com.af.plugins.UrlTools;
import com.aote.ThreadResource;
import com.aote.rs.utils.FileConfig;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public class ThirdDataGet {
    private static final int CONNECT_TIMEOUT = 600000;// 设置连接建立的超时时间
    private static final int SOCKET_TIMEOUT = 600000;
    private static RestTools restTools;

    /**
     * 增量获取组织信息
     * @return
     * @throws Exception
     */
    public JSONObject getIncrementlOrgData() throws Exception {
        String masterpost = masterpost("getOrgData", "increment");
        return new JSONObject(masterpost);
    }


    /**
     * 获取所有组织信息
     */
    public JSONObject getAllOrdData() throws Exception {
        String masterpost = masterpost("getOrgData", "all");
        return new JSONObject(masterpost);
    }


    /**
     * 增量获取用户
     * @return
     * @throws Exception
     */
    public JSONObject getIncrementlUserData() throws Exception {
        System.out.println("开始获取用户西悉尼");
        String masterpost = masterpost("getUserData", "increment");
        System.out.println("获取用户西悉尼  "+masterpost);
        return new JSONObject(masterpost);
    }


    /**
     * 获取所有用户信息
     */
    public JSONObject getAllUserData() throws Exception {
        String masterpost = masterpost("getUserData", "all");
        return new JSONObject(masterpost);
    }


    /**
     * 登录的请求发送，获取cookie
     */
    public String getLogin() throws Exception {
        JSONArray resultjson = new JSONArray();
        JSONObject urldata = FileConfig.getjsonfromfile("MasterDataUrl.json");
        //登录请求
        String loginurl = (String) urldata.get("login");
        JSONObject logindata = new JSONObject();
        logindata.put("username",(String) urldata.get("username"));
        logindata.put("password",(String) urldata.get("password"));
        logindata.put("Tenant",(String) urldata.get("Tenant"));
        logindata.put("language",(String) urldata.get("language"));
        logindata.put("Authenstrategy",(String) urldata.get("Authenstrategy"));
        StringBuffer requeststr = new StringBuffer();
        Iterator<String> keys = logindata.keys();
        while(keys.hasNext()){
            String key = keys.next();
            String value = (String) logindata.get(key);
            requeststr.append(key);
            requeststr.append("=");
            requeststr.append(value);
            if(keys.hasNext()){
                requeststr.append("&");
            }
        }
        //获取用户数据
        String usergeturl = (String) urldata.get("getUserData");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Connection","keep-alive");
        jsonObject.put("Cache-Control","max-age=0");
        jsonObject.put("Content-Type","application/x-www-form-urlencoded");
        jsonObject.put("Accept-Encoding","gzip, deflate, br");
        jsonObject.put("Accept","text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8");
        //1. 先登录,后获取数据
        String reponse = requestLogin2(loginurl, requeststr.toString(), jsonObject.toString(), new HttpPost());
        return reponse;
    }


    /**
     * 登录请求进行或登录的cookie
     * @param path
     * @param value
     * @param headersStr
     * @param base
     * @return
     */
    public  String requestLogin2(String path, String value, String headersStr, HttpEntityEnclosingRequestBase base){
        if (!path.startsWith("http")) {
            // 从系统配置中获得path对应的地址
            path = UrlTools.getUrl(path);
        }
        //设置请求地址
        base.setURI(URI.create(path));
        //设置请求体
        if(value != null && !"".equals(value)){
            StringEntity se = new StringEntity(value, StandardCharsets.UTF_8);
            base.setEntity(se);
        }
        //设置请求头
        setHeaders(headersStr, base);

        //设置超时时间
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectionRequestTimeout(CONNECT_TIMEOUT)
                .setConnectTimeout(CONNECT_TIMEOUT)
                .setSocketTimeout(SOCKET_TIMEOUT).build();
        base.setConfig(requestConfig);
        //发送请求
        DefaultHttpClient client = new DefaultHttpClient();
        String cookieget = "";
        try {
            HttpResponse response = client.execute(base);
            String result = EntityUtils.toString(response.getEntity(),"utf-8");
            org.apache.http.Header[] allHeaders = response.getAllHeaders();
            for(org.apache.http.Header header:allHeaders){
                if(header.getName().equals("Set-Cookie"))
                    cookieget=header.getValue();
            }

        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return cookieget;
    }


    /**
     * 设置请求头，如果线程局部变量里有cookie，把cookie也发送过去
     * @param headersStr
     * @param base
     */
    private  void setHeaders(String headersStr, HttpEntityEnclosingRequestBase base) {
        // 设置token
        String token = ThreadResource.Token.get();
        if (token != null) {
            base.setHeader("Token", token);
        }

        // 设置其他请求头
        if (headersStr != null && !"".equals(headersStr)) {
            JSONObject headers = new JSONObject(headersStr);
            Iterator keys = headers.keys();
            while (keys.hasNext()) {
                String key = (String) keys.next();
                String val = headers.getString(key);
                base.setHeader(key, val);
            }
        }
    }

    /**
     * 公共请求发送方法
     * @param infotype
     * @param model
     * @return
     * @throws Exception
     */
    private String masterpost(String infotype,String model) throws Exception {
        JSONArray resultjson = new JSONArray();
        JSONObject urldata = FileConfig.getjsonfromfile("MasterDataUrl.json");
        //获取用户数据
        String usergeturl = (String) urldata.get(infotype);
        //请求头
        String cookie = getLogin();
        cookie = checkcookie(cookie);
        System.out.println("获取到的cookie： "+cookie);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Cookie",cookie);
        jsonObject.put("Content-Type","application/json");
        jsonObject.put("X-ECC-Current-Tenant","10000");
        //  请求体
        JSONObject bodyObject = new JSONObject();
        bodyObject.put("CODE","");
        bodyObject.put("ACCESSMETHOD",model);
        bodyObject.put("TARGETSys","OA");

        //1. 先登录,后获取数据
        String postresult = restTools.post(usergeturl, bodyObject.toString(),jsonObject.toString());
        return postresult;
    }

    /**
     * 处理cookie,用来保持session
     * @throws Exception
     */
    public String checkcookie(String cookie){
        if(cookie == null || "".equals(cookie)) return "";
        cookie = cookie.replaceAll(" Domain=192.168.10.17; ","");
        return cookie.replaceAll(" SameSite=Lax","");
    }

}
