package com.aote.rs.jm.aes;


import com.aote.rs.utils.FileConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.UUID;


@Component
public class Tools {
    private static final Logger LOGGER = Logger.getLogger(Tools.class);
    private static JSONObject thirdFiliter;

    public Tools() throws Exception {
    }

    /**
     * 发出加密请求并获得解密后的数据
     * @param url 请求地址
     * @param content 请求内容
     * @param header 请求头
     * @return 解密后的数据
     * @throws Exception 异常
     */
    public static JSONObject post(String url, JSONObject content, JSONObject header) throws Exception {
        Iterator<String> keys = thirdFiliter.keys();
        //验证accesskey是否合法
        String sToken = "";
        String sCorpID = "";
        String sEncodingAESKey = "";
        while(keys.hasNext()){
            String key = keys.next();
            sToken = thirdFiliter.getString("appSecret");
            sCorpID = thirdFiliter.getString("CorpID");
            sEncodingAESKey = thirdFiliter.getString("EncodingAESKey");
        }
        System.out.println(sToken+" "+sCorpID+" "+sEncodingAESKey);
        String sReqTimeStamp = String.valueOf(System.currentTimeMillis());
        String sReqNonce = UUID.randomUUID().toString();
        SignTempCrypt signTempCrypt = new SignTempCrypt(sToken,sEncodingAESKey,sCorpID);
        //数据加密
        LOGGER.debug("加密内容："+content+"/"+sReqTimeStamp+"/"+sReqNonce+"/"+sCorpID);
        JSONObject encryptJson = signTempCrypt.encrypt(content, sReqTimeStamp, sReqNonce,sCorpID);
        String encrypt = encryptJson.getString("metaData").replace("\n", "");
        LOGGER.debug(encrypt);
        //设置请求头
        header = SignTempCrypt.getRestHeader(encrypt);
        LOGGER.debug("加密请求头："+header);
        //从加密数据中获取请求体
        String body = encryptJson.getString("content");
        LOGGER.debug("加密请求体："+body);
        //发起请求并收到接收方加密的响应
        JSONObject result = post2(url,body,header.toString());
        //获取响应头
        JSONObject responseHeader = result.getJSONObject("header");
        //获取响应体
        String responseBody = result.getString("body");
        LOGGER.debug("解析前响应头："+responseHeader);
        LOGGER.debug("解析前响应体："+responseBody);
        //解密数据
        return signTempCrypt.decrypt(responseBody, responseHeader.getString("msg_signature"), responseHeader.getString("timestamp"), responseHeader.getString("nonce"));
    }

    /**
     * 解密响应数据
     * @param responseBody 响应数据内容
     * @param responseHeader 响应数据头
     * @return 明文数据
     * @throws Exception 异常
     */
    public static JSONObject decrypt(String responseBody, JSONObject responseHeader) throws Exception {
        thirdFiliter = FileConfig.getjsonfromfile("thirdFiliter.json");
        Iterator<String> keys = thirdFiliter.keys();
        //验证accesskey是否合法
        String sToken = "";
        String sCorpID = "";
        String sEncodingAESKey = "";
        while(keys.hasNext()){
            String key = keys.next();
            sToken = thirdFiliter.getString("appSecret");
            sCorpID = thirdFiliter.getString("CorpID");
            sEncodingAESKey = thirdFiliter.getString("EncodingAESKey");
        }
        SignTempCrypt signTempCrypt = new SignTempCrypt(sToken,sEncodingAESKey,sCorpID);
        //解密
        return signTempCrypt.decrypt(responseBody, responseHeader.getString("msg_signature"), responseHeader.getString("timestamp"), responseHeader.getString("nonce"));
    }

    /**
     * 加密请求数据
     * @param content 需要加密的数据
     * @return 加密数据
     * @throws Exception 异常
     */
    public static JSONObject encrypt(JSONObject content) throws Exception {
        thirdFiliter = FileConfig.getjsonfromfile("thirdFiliter.json");
        Iterator<String> keys = thirdFiliter.keys();
        //验证accesskey是否合法
        String sToken = "";
        String sCorpID = "";
        String sEncodingAESKey = "";
        while(keys.hasNext()){
            String key = keys.next();
            sToken = thirdFiliter.getString("appSecret");
            sCorpID = thirdFiliter.getString("CorpID");
            sEncodingAESKey = thirdFiliter.getString("EncodingAESKey");
        }
        String sReqTimeStamp = String.valueOf(System.currentTimeMillis());
        String sReqNonce = UUID.randomUUID().toString();
        SignTempCrypt signTempCrypt = new SignTempCrypt(sToken,sEncodingAESKey,sCorpID);
        //加密
        LOGGER.debug("加密内容："+content+"/"+sReqTimeStamp+"/"+sReqNonce+"/"+sCorpID);
        JSONObject encryptJson = signTempCrypt.encrypt(content, sReqTimeStamp, sReqNonce,sCorpID);
        String encrypt = encryptJson.getString("metaData").replace("\n", "");
        LOGGER.debug(encrypt);
        //设置请求头
        JSONObject header = SignTempCrypt.getRestHeader(encrypt);
        LOGGER.debug("加密请求头："+header);
        //获取请求体
        String body = encryptJson.getString("content");
        LOGGER.debug("加密请求体："+body);
        JSONObject result = new JSONObject();
        result.put("header",header);
        result.put("content",body);
        return result;
    }

    /**
     * 发送带请求体字符串的post请求，返回包含响应头
     *
     * @param path  请求路径
     * @param value 请求参数
     * @return body 响应信息，header 响应头
     */
    public static JSONObject post2(String path, String value, String header) {
        return request2(path,value,header,new HttpPost());
    }

    /**
     * 发送通用Http请求 包含响应头
     * @param path  请求路径
     * @param value 请求参数
     * @param headersStr    请求头
     * @param base  请求类型
     * @return  响应结果 and 响应头
     */
    public static JSONObject request2(String path, String value, String headersStr, HttpEntityEnclosingRequestBase base){
        //设置请求地址
        base.setURI(URI.create(path));
        //设置请求体
        if(value != null && !"".equals(value)){
            StringEntity se = new StringEntity(value, StandardCharsets.UTF_8);
            base.setEntity(se);
        }
        //设置请求头
        setHeaders(headersStr, base);
        //发送请求
        HttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpResponse response = httpClient.execute(base);
            int code = response.getStatusLine().getStatusCode();
            JSONObject result = new JSONObject();
            // 获取数据成功，返回数据
            if (code == 200) {
                JSONObject headerObject = new JSONObject();
                Header[] headerArray = response.getAllHeaders();
                for(Header header : headerArray) {
                    headerObject.put(header.getName(),header.getValue());
                }
                result.put("header",headerObject);
                result.put("body",EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8));
                return result;
            } else {
                result.put("body",response.getStatusLine().getReasonPhrase());
                return result;
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 设置请求头，如果线程局部变量里有Token，把Token也发送过去
     * @param headersStr 请求头字符串
     * @param base 请求实体
     */
    private static void setHeaders(String headersStr, HttpEntityEnclosingRequestBase base) {
        // 设置其他请求头
        if (headersStr != null && !"".equals(headersStr)) {
            JSONObject headers = new JSONObject(headersStr);
            Iterator<String> keys = headers.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                String val = headers.getString(key);
                base.setHeader(key, val);
            }
        }
    }
}
