package com.af.timejob;

import com.aote.rs.LogicService;
import file.ReadFile;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@Lazy(false)
public class Safevalueinfo {

    static Logger log = Logger.getLogger(LogicService.class);

    @Autowired
    private LogicService logicService;

    @Scheduled(cron = "0 30 0 * * ?") //每天23点
    public void doJob(){
        log.debug("进入了定时器执行定时任务:安检置换信息处理");
        ReadFile file =new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/timerConfig.json"));
        log.debug("获取到的执行配置为---》"+conf.get("safevalueinfo"));
        if ((boolean) conf.get("safevalueinfo")){
            try {
                log.debug("开始安检置换信息处理");
                logicService.xtSave("getSafeValueinfo", new JSONObject().put("data", new JSONObject().toString()).toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("未配置启动自动下发");
        }
    }

}

